

// Includes, project.
#include "CameraViewerComponent.hpp"


// Includes, pacpus.
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/DbiteFileTypes.h>
#include <Pacpus/kernel/DbiteException.h>

// Includes, standard.
#include <stdexcept>
#include <QMetaType>
#include <iostream>


using namespace pacpus;


ComponentFactory<CameraViewerComponent> sFactory("CameraViewerComponent");

CameraViewerComponent::CameraViewerComponent(QString const& name)
    :ComponentBase(name)
{
    
}

CameraViewerComponent::~CameraViewerComponent()
{


}

void
CameraViewerComponent::stopActivity()
{

}

void
CameraViewerComponent::startActivity()
{  
	qRegisterMetaType<cv::Mat>("cv::Mat");
	connect(this, SIGNAL(doDisplay(cv::Mat)), SLOT(DisplayFrame(cv::Mat)));
}

ComponentBase::COMPONENT_CONFIGURATION
CameraViewerComponent::configureComponent(XmlComponentConfig config)
{
  return ComponentBase::CONFIGURED_OK;
}

void CameraViewerComponent::addInputs()
{
    addInput<cv::Mat, CameraViewerComponent>("image", &CameraViewerComponent::process);
}

void CameraViewerComponent::DisplayFrame(cv::Mat const& frame)
{
	cv::imshow(getName().toStdString(), frame);
}

/*! process function from the Display class with a cv:Mat parameter
Emit the signal to diplay the frame
*/
void CameraViewerComponent::process(cv::Mat const& frame)
{
	emit doDisplay(frame);
}



