/*********************************************************************
// created:    2007/04/12 - 16:30

//
// author:     Elie Al Alam & Gerald Dherbomez
// 
// version:    $Id: $
//
// purpose:    Dbite Player Image Manager header file
*********************************************************************/

#ifndef DbtPlyOpenCVManager_H
#define DbtPlyOpenCVManager_H

#include <qobject.h>

#include "Pacpus/DbitePlayer/DbtPlyFileManager.h"
#include "CameraPlayerConfig.h"

// Includes, opencv.
#if (OPENCV_MAJOR == 3)
#   include <opencv2/opencv.hpp>
#   include <opencv2/highgui.hpp>
#else
#   include <opencv/cv.h>
#   include <opencv/highgui.h>
#endif

namespace pacpus {
    

class CAMERAPLAYER_API DbtPlyOpenCVManager
        : public DbtPlyFileManager
{
    Q_OBJECT

public:
    DbtPlyOpenCVManager(QString name);
    ~DbtPlyOpenCVManager();

    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

public:
    virtual void addInputs();
    virtual void addOutputs();


protected:
    void processData(road_time_t, road_timerange_t, void * dataBuffer);
    virtual void startActivity();
    virtual void stopActivity();

};

} // namespace pacpus

#endif // DbtPlyOpenCVManager_H
