#ifndef VISLABIMAGEPROCESSOR_H
#define VISLABIMAGEPROCESSOR_H

// Includes, project.
#include <Pacpus/PacpusTools/AsyncWorkerBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <Pacpus/kernel/DbiteFileTypes.h>
#include <Pacpus/kernel/DbiteException.h>

// Includes, qt.
#include <QTimer>

#include <lib3dv/device.h>

#if (OPENCV_MAJOR == 3)
#include <opencv2/opencv.hpp>
#include <opencv2/highgui.hpp>
#else
#include <opencv/cv.h>
#include <opencv/highgui.h>
#endif

class VislabImageProcessor
{
public:
    VislabImageProcessor(const QString& name, lib3dv::image::type::types imageType);
    void image_callback(boost::shared_ptr<const lib3dv::image>);
    virtual void process(cv::Mat const& frame) = 0;
    QString getName();

private:
    QString mName;
    lib3dv::image::type::types mImageType;
};

#endif // VISLABIMAGEPROCESSOR_H
