#ifndef DEF_VISLAB_VIEWER_COMPONENT_HPP
#define DEF_VISLAB_VIEWER_COMPONENT_HPP


// Includes, qt.
#include <QTimer>
#include <QObject>

// Includes, pacpus.
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <Pacpus/kernel/pacpus.h>

// Includes, opencv.
#include <opencv/cv.h>
#include <opencv/highgui.h>

#include "VislabImageProcessor.h"

#ifdef WIN32
#   ifdef VISLAB_VIEWER_COMPONENT_EXPORTS
#       define VISLAB_VIEWER_COMPONENT_API __declspec(dllexport)
#   else
#       define VISLAB_VIEWER_COMPONENT_API __declspec(dllimport)
#   endif
#else
#   define VISLAB_VIEWER_COMPONENT_API
#endif

namespace pacpus
{
  class VISLAB_VIEWER_COMPONENT_API VislabViewerComponent
    : public QObject
    , public ComponentBase
  {
    Q_OBJECT
    public:

      //device(){}
      /// Ctor of VislabViewerComponent.
		//VislabViewerComponent(const QString& windowName, lib3dv::image::type::types imageType);

		VislabViewerComponent(QString const& name);

		/// Dtor of VislabViewerComponent
          ~VislabViewerComponent();

      /// Stop the processing thread.
      virtual void stopActivity();

      /// Start the processing thread.
      virtual void startActivity();

      /// Configure the component.
      virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
	  void process(cv::Mat const& frame);

      // Working thread, grabbing frame from a webcam.
      DbiteFile mDBTFile;

    public:
      virtual void addInputs();
	  QString getName();
      //device(){}

      private:
    std::string mOutputFileName;
    Q_SIGNAL void doDisplay(cv::Mat const& frame);
	Q_SLOT void DisplayFrame(cv::Mat const& frame);
	QString mName;


  };
}

#endif
