
// Includes, project.
#include "VislabViewerComponent.hpp"


// Includes, pacpus.
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/DbiteFileTypes.h>
#include <Pacpus/kernel/DbiteException.h>

// Includes, standard.
#include <stdexcept>
#include <lib3dv/device.h>
#include <QMetaType>
#include <iostream>


using namespace pacpus;

// Declare the logger and register the new component.
//DECLARE_STATIC_LOGGER("pacpus.component.vislabCamera")
//REGISTER_COMPONENT(VislabViewerComponent, "Camera");

ComponentFactory<VislabViewerComponent> sFactory("VislabViewerComponent");

VislabViewerComponent::VislabViewerComponent(QString const& name)
    :ComponentBase(name)
{
    
}

VislabViewerComponent::~VislabViewerComponent()
{


}

void
VislabViewerComponent::stopActivity()
{

}

void
VislabViewerComponent::startActivity()
{  
	qRegisterMetaType<cv::Mat>("cv::Mat");
	connect(this, SIGNAL(doDisplay(cv::Mat)), SLOT(DisplayFrame(cv::Mat)));
}

ComponentBase::COMPONENT_CONFIGURATION
VislabViewerComponent::configureComponent(XmlComponentConfig config)
{
  return ComponentBase::CONFIGURED_OK;
}

void VislabViewerComponent::addInputs()
{
    addInput<cv::Mat, VislabViewerComponent>("image", &VislabViewerComponent::process);
    addInput<cv::Mat, VislabViewerComponent>("disparity", &VislabViewerComponent::process);
}

void VislabViewerComponent::DisplayFrame(cv::Mat const& frame)
{
	cv::imshow(getName().toStdString(), frame);
}

/*! process function from the Display class with a cv:Mat parameter
Emit the signal to diplay the frame
*/
void VislabViewerComponent::process(cv::Mat const& frame)
{
	emit doDisplay(frame);
}

QString VislabViewerComponent::getName()
{
	return mName;
}



