/*********************************************************************
// created:    2007/04/12 - 16:30

//
// author:     Elie Al Alam & Gerald Dherbomez
// 
// version:    $Id: DbtPlyGstManager.cpp 1203 2012-08-02 11:58:15Z morasjul $
//
// purpose:    Dbite Player Gst Manager implementation
*********************************************************************/

#include "DbtPlyGstManager.h"

#include <qapplication.h>

//#include "kernel/ComponentManager.h"

namespace pacpus {

// Construction de la fabrique de composant DbtPlyTrigger
static ComponentFactory<DbtPlyGstManager> sFactory("DbtPlyGstManager"); 

DbtPlyGstManager::DbtPlyGstManager(QString name)
    : DbtPlyFileManager (name)
{

}

DbtPlyGstManager::~DbtPlyGstManager()
{ 

}

void DbtPlyGstManager::processData(road_time_t t, road_timerange_t tr , void * buf)
{
	// no data available
	if (!buf) {
		LOG_DEBUG("no data available: NULL buffer");
		return;
	}
	// make local copy of GGA frame
	memcpy(&mGst.frame, buf, sizeof(trame_gst));
	mGst.time = t;
	mGst.timerange = tr;

	// send GGA data to output
	checkedSend(outGst, mGst);
  
	//old val = (trame_gst*)(buf);

}

ComponentBase::COMPONENT_CONFIGURATION DbtPlyGstManager::configureComponent(XmlComponentConfig config)
{
  DbtPlyFileManager::configureComponent(config);

  return ComponentBase::CONFIGURED_OK;
}


void DbtPlyGstManager::startActivity()
{   
  DbtPlyFileManager::startActivity();

  outGst = getTypedOutput<TimestampedGstFrame, DbtPlyGstManager>("gst");

  // user interface 
  if (hasGui())
    displayUI();

}


void DbtPlyGstManager::stopActivity()
{ 
  DbtPlyFileManager::stopActivity();
}

void DbtPlyGstManager::addOutputs()
{
	// empty: no output
	addOutput<TimestampedGstFrame, DbtPlyGstManager>("gst");
}

void DbtPlyGstManager::displayUI()
{
	// TODO
	LOG_WARN("GUI not implemented");
}

} // namespace pacpus
