// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @version $Id: ComponentBase.cpp 76 2013-01-10 17:05:10Z kurdejma $

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/Log.h>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.ComponentBase");

ComponentBase::ComponentBase(const QString& componentName)
  : m_componentName(componentName)
  , m_isActive(false)
  , m_isRecording(true)
  , m_manager(NULL)
  , m_ui(NULL)
  , m_componentState(NOT_MONITORED)
{
    LOG_TRACE("constructor");
    // Get a pointer on the instance of ComponentManager.
    m_manager = ComponentManager::getInstance();
    LOG_INFO("component " << name() << " was created");
}

ComponentBase::~ComponentBase()
{  
    LOG_TRACE("destructor");
}

bool ComponentBase::isActive() const
{
    return m_isActive;
}

void ComponentBase::setActive(bool isActive)
{
    m_isActive = isActive;
}

bool ComponentBase::isRecording() const
{
    return m_isRecording;
}

void ComponentBase::setRecording(bool isRecording)
{
    m_isRecording = isRecording;
}

const XmlComponentConfig ComponentBase::xmlParameters() const
{
    return param;
}

int ComponentBase::startComponent()
{
    if (isActive()) {
        LOG_DEBUG("component already started, cannot (re-)start");
        return false;
    }

    setActive(true);
    startActivity();
    
    return true;
}

int ComponentBase::stopComponent()
{
    if (!isActive()) {
        LOG_DEBUG("component already stopped, cannot (re-)stop");
        return false;
    }
    
    setActive(false);
    stopActivity();
    
    return true;
}

void ComponentBase::setState(const COMPONENT_STATE state)
{
    m_componentState = state;
}

// FIXME: this should be const.
ComponentBase::COMPONENT_STATE ComponentBase::getState()
{
    COMPONENT_STATE state = m_componentState;
    if (ComponentBase::NOT_MONITORED != m_componentState) {
        m_componentState = ComponentBase::MONITOR_NOK;
    }
    return state;
}

ComponentBase::COMPONENT_CONFIGURATION ComponentBase::configurationState() const
{
    return m_configurationState;
}

void ComponentBase::setConfigurationState(COMPONENT_CONFIGURATION state)
{
    m_configurationState = state;
}

bool ComponentBase::isConfigured() const
{
    return (m_configurationState == CONFIGURED_OK);
}

QString ComponentBase::name() const
{
    return m_componentName;
}

QString ComponentBase::getName() const
{
    return m_componentName;
}

ComponentBase::InputsMap & ComponentBase::inputs()
{
    return m_inputs;
}

const ComponentBase::InputsMap & ComponentBase::inputs() const
{
    return m_inputs;
}

ComponentBase::OutputsMap & ComponentBase::outputs()
{
    return m_outputs;
}

const ComponentBase::OutputsMap & ComponentBase::outputs() const
{
    return m_outputs;
}

InputInterfaceBase * ComponentBase::getInput(QString inputName) const
{
    if (inputs().contains(inputName)) {
        return inputs()[inputName];
    }
    LOG_WARN("Component " << name() << " does not contain input " << inputName);
    return NULL;
}

OutputInterfaceBase * ComponentBase::getOutput(QString outputName) const
{
/*    QList<QString> keys = output.keys();
    for(int i=0; i<keys.size();++i)
        LOG_INFO("Key : " << keys[i])*/;

    if (outputs().contains(outputName)) {
        return outputs()[outputName];
    }
    LOG_WARN("Component " << name() << " does not containt output " << outputName);
    return NULL;
}
