// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @version $Id: DbtPlyTrigger.cpp 76 2013-01-10 17:05:10Z kurdejma $

#include <Pacpus/DbitePlayer/DbtPlyTrigger.h>

#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/Log.h>

namespace pacpus {

DECLARE_STATIC_LOGGER("pacpus.core.DbtPlyTrigger");

// Construction de la fabrique de composant DbtPlyTrigger
//static ComponentFactory<DbtPlyTrigger> factory("DbtPlyTrigger");

DbtPlyTrigger::DbtPlyTrigger(QString name)
    : ComponentBase(name)
    , mEngine(NULL)
{
}

DbtPlyTrigger::~DbtPlyTrigger()
{ 
}

void DbtPlyTrigger::addInputs()
{
    // empty: no inputs
}

void DbtPlyTrigger::addOutputs()
{
    // empty: no outputs
}

ComponentBase::COMPONENT_CONFIGURATION DbtPlyTrigger::configureComponent(XmlComponentConfig /*config*/)
{
    ComponentManager * mgr = ComponentManager::getInstance();
    // we get a pointer to the engine component
    mEngine = dynamic_cast<DbtPlyEngine *>(mgr->getComponent("dbiteEngine"));
    if (NULL == mEngine) {
        LOG_FATAL("cannot get a pointer of the 'dbiteEngine' component");
        return CONFIGURED_FAILED;
    }
    connect(this, SIGNAL(triggerSig()),
            mEngine,SLOT(engReceiver()),
            Qt::DirectConnection);

    return CONFIGURED_OK;
}

void DbtPlyTrigger::startActivity()
{   
    start();
}

void DbtPlyTrigger::stopActivity()
{ 
}

// The thread is started when the user press the play button
void DbtPlyTrigger::run()
{
#ifdef WIN32
    timeBeginPeriod(1);
#endif

    while(isActive()) {
        if (mEngine->isPlaying()) {
            Q_EMIT triggerSig();
        }
        msleep(1);
    }

#ifdef WIN32
    timeEndPeriod(1);
#endif 
}

} // namespace pacpus
