#ifndef CONNECTIONBASE_H
#define CONNECTIONBASE_H

#include <Pacpus/kernel/pacpus.h>

namespace pacpus {

class AbstractInterface;

class PACPUSLIB_API ConnectionBase
{
public:
    ConnectionBase(AbstractInterface * interface, int priority)
        : m_interface(interface)
        , m_priority(priority)
    {}

    ~ConnectionBase()
    {}

    AbstractInterface *  getInterface() const
    {
        return m_interface;
    }

    int getPriority() const
    {
        return m_priority;
    }

    bool operator==(ConnectionBase const &c)
    {
        return getInterface() == c.getInterface()
            && getPriority() == c.getPriority()
            ;
    }

private:
    AbstractInterface * m_interface;
    int m_priority;
};

} // namespace pacpus

#endif // CONNECTIONBASE_H
