/*********************************************************************
//  created:    2007/11/13 - 10:47
//  filename:   AlascaSocket.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Management of the socket connection with the Alasca
*********************************************************************/

#include "AlascaSocket.h"

#include <QCoreApplication>
#include <QDebug>

#include "AlascaComponent.h"
#include "Pacpus/kernel/Log.h"

namespace pacpus {

DECLARE_STATIC_LOGGER("pacpus.base.AlascaSocket");

//////////////////////////////////////////////////////////////////////////
/// Constructor
AlascaSocket::AlascaSocket(QObject * parent)
{
  socket = new QTcpSocket(this); 
  connect( socket, SIGNAL(connected()), this,SLOT(socketConnected()) );
  connect( socket, SIGNAL(disconnected()),this, SLOT(socketConnectionClosed()) );
  connect( socket, SIGNAL(readyRead()),this, SLOT(socketReadyRead()) );
  connect( socket, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(socketError(QAbstractSocket::SocketError)) );
  myParent = (AlascaComponent *) parent;
}

//////////////////////////////////////////////////////////////////////////
/// Destructor
AlascaSocket::~AlascaSocket()
{
    delete socket;
}

//////////////////////////////////////////////////////////////////////////
/// public slot
/// connection to server
void AlascaSocket::connectToServer(QString host, int port)
{
  qDebug("trying to connect to server");
  socket->connectToHost(host,port);
}

//////////////////////////////////////////////////////////////////////////
/// protected slot
int AlascaSocket::socketConnected()
{ 
  qDebug() << "we are connected to the server " << socket->peerName().toLatin1() 
    << " at the port " << socket->peerPort() << " via the socket " << socket->socketDescriptor();
  emit configuration(); 
  
 return 1;
}

//////////////////////////////////////////////////////////////////////////
/// protected slot
void AlascaSocket::socketConnectionClosed()
{
  qDebug("the connection was closed");
}

//////////////////////////////////////////////////////////////////////////
/// protected slot
/// new incoming data to read
void AlascaSocket::socketReadyRead()
{   
    AlascaFrame * frame = new AlascaFrame();
  frame->time = road_time(); 
  frame->size = socket->bytesAvailable(); 
  frame->msg = new char[frame->size]; 

  if (!frame->msg) {
      LOG_FATAL("cannot allocate memory of size " << frame->size
                << " - file: " << __FILE__
                << " line: " << __LINE__
                );
  }

  frame->size = socket->read( frame->msg,  frame->size); 

  AlascaFrameEvent *e = new AlascaFrameEvent; 
  e->frame = frame; 
  QCoreApplication::postEvent(myParent, e);  
}

//////////////////////////////////////////////////////////////////////////
/// protected slot
void AlascaSocket::socketError(QAbstractSocket::SocketError e)
{
  qWarning("socket error number %d",e); 
}

//////////////////////////////////////////////////////////////////////////
/// Send data to server via a text stream
void AlascaSocket::sendToServer(QString data)//a adapter aux données binaires
{
  mutex.lock();
  QTextStream os(socket);
  os << data << endl;
  mutex.unlock();
  qDebug() << "data sent to server: " << data.toLatin1();//a adapter aussi
}

} // namespace pacpus
