#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

# ========================================
# Build-specific configuration
# ========================================
if(IS_BUILDING_PACPUS)
    set(PACPUS_INSTALL_DIR    ${CMAKE_INSTALL_PREFIX}   CACHE FILEPATH "Installation directory for the library")
    set(PACPUS_INSTALL_3RD    FALSE                     CACHE BOOL      "Installation of the 3rd party")
endif()

# ========================================
# Global configuration
# ========================================
set(PACPUS_USE_LOG      TRUE  CACHE BOOL "Logging using log4cxx, the library is required")
set(PACPUS_INSTALL_3RD  FALSE CACHE BOOL "Installation of the 3rd party")
set(PACPUS_BUILD_DOC    FALSE CACHE BOOL "Whether build the documentation - requires Doxygen")
set(PACPUS_BUILD_EXAMPLES FALSE CACHE BOOL "Whether build the examples")
set(PACPUS_USE_SOLUTION_FOLDERS  FALSE CACHE BOOL "Use solution folders to classify projects, works in MS Visual Studio")

set(QT5      FALSE CACHE BOOL " Use Qt5 or Qt4")

if(PACPUS_USE_SOLUTION_FOLDERS)
    if(CMAKE_VERSION VERSION_GREATER "2.8.0")
        set_property(GLOBAL PROPERTY USE_FOLDERS ON)
    else()
        message(AUTHOR_WARNING "Folders are only supported with CMake 2.8.0 and newer, and MSVC 2005 and newer except for 2005/2008/2010 Express Edition")
    endif()
endif(PACPUS_USE_SOLUTION_FOLDERS)
