/*********************************************************************
// created:    2013/07/10
// filename:   PacpusSerialPort.h
//
// author:     Julien Moras
//
// version:    $Id: $
//
// purpose:    This class defines a Qt 5.1 driver for serial port
*********************************************************************/
#ifndef _PacpusSerialPort_H_
#define _PacpusSerialPort_H_

#include <QtSerialPort/QSerialPort>
#include <QtSerialPort/QSerialPortInfo>
#include <QThread>

#include <Pacpus/kernel/ComponentBase.h>

namespace pacpus {

class PacpusSerialPort
    : public QObject
    , public ComponentBase
{
    Q_OBJECT
    
public:
    typedef enum {
        ASCII,
        BINARY
    } DataMode;

    PacpusSerialPort(QString name);
    ~PacpusSerialPort();

protected:
    void startActivity(); /*!< to start the processing thread */
    void stopActivity(); /*!< to stop the processing thread */
    ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    virtual void addInputs();
    virtual void addOutputs();
    void processInputFrame(const QByteArray &);

private Q_SLOTS:
    void readData();

private:
    QThread       thread_;

    QSerialPort * serialPort;

    QString portName;
    QSerialPort::Direction direction;
    QSerialPort::BaudRate baudRate;
    QSerialPort::DataBits dataBits;
    QSerialPort::Parity parity;
    QSerialPort::StopBits stopBits;
    QSerialPort::FlowControl flowControl;
    QSerialPort::DataErrorPolicy errorPolicy;
    DataMode dataMode;

    QByteArray buffer;

    QString sepChar;
    QString startChar;
    QString stopChar;

    int minPacketSize;

    bool log;
};

} // end namespace

#endif
