#include <Pacpus/kernel/InputOutputBase.h>

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/ConnectionBase.h>
#define CONNECT_INTERFACE_EXPORTS
#include <Pacpus/kernel/InputOutputInterface.h>
#undef CONNECT_INTERFACE_EXPORTS
#include <Pacpus/kernel/Log.h>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.InputOutputInterface");

////////////////////////////////////////////////////////////////////////////////

AbstractInterface::AbstractInterface(QString name, ComponentBase * component, QObject * parent)
    : m_name(name)
    , m_component(component)
    , QObject(parent)
{
    LOG_DEBUG("constructing abstract connection '" << getName() << "'");
}

AbstractInterface::~AbstractInterface()
{}

QString AbstractInterface::getSignature() const
{
    return getComponent()->getName() + '.' + getName();
}

QString AbstractInterface::getName() const
{
    return m_name;
}

QList<ConnectionBase> & AbstractInterface::connections()
{
    return m_connections;
}

const QList<ConnectionBase> & AbstractInterface::getConnections() const
{
    return m_connections;
}

ComponentBase * AbstractInterface::component()
{
    return m_component;
}

const ComponentBase * AbstractInterface::getComponent() const
{
    return m_component;
}

void AbstractInterface::addConnection(ConnectionBase connection)
{
    m_connections.append(connection);
}

bool AbstractInterface::removeConnection(ConnectionBase connection)
{
    return m_connections.removeOne(connection);
}

bool AbstractInterface::hasConnection()
{
    return m_connections.size() > 0;
}

////////////////////////////////////////////////////////////////////////////////

InputInterfaceBase::InputInterfaceBase(QString name, ComponentBase * component, QObject * parent)
    : AbstractInterface(name, component, parent)
{}

InputInterfaceBase::~InputInterfaceBase()
{}

// TODO for serialization prupose (not yet implemented !!!)
void InputInterfaceBase::customEvent(QEvent* e)
{
    //if (event->type())
    //TODO get event Type anf call callback function

    PacpusEvent * event = dynamic_cast<PacpusEvent *>(e);
    QByteArray buf;
    QDataStream out(&buf, QIODevice::WriteOnly);
    event->streamOut(out);
    // Callback QByteArray
}

InputInterfaceBase::ReadingMode & InputInterfaceBase::readingMode()
{
    return m_readingMode;
}

const InputInterfaceBase::ReadingMode & InputInterfaceBase::readingMode() const
{
    return m_readingMode;
}

void InputInterfaceBase::setReadingMode(ReadingMode mode)
{
    m_readingMode = mode;
}

PacpusEvent * InputInterfaceBase::getEventTemplate()
{
    // TODO: check
    return new PacpusEvent(GENERIC_EVENT);
}

////////////////////////////////////////////////////////////////////////////////

QStringList OutputInterfaceBase::getInputConnectedList()
{
    QStringList list;
    for (QList<ConnectionBase>::iterator it = connections().begin(); it != connections().end(); ++it) {
        list.append(it->getInterface()->getName());
    }
    return list;
}

// TODO for serialization prupose (not yet implemented !!!)
void OutputInterfaceBase::send(/*const*/ QByteArray & data)
{
    // TODO check at least one Typed connection

    for (QList<ConnectionBase>::iterator it = connections().begin(); it!=connections().end(); ++it) {
            QDataStream in(&data,QIODevice::ReadOnly);
            PacpusEvent * event = dynamic_cast<InputInterfaceBase*>(connections().at(0).getInterface())->getEventTemplate();
            event->streamIn(in);
            QApplication::postEvent(it->getInterface(),event,it->getPriority());
    }
}
