#ifndef IN_OUT_BASE_H
#define IN_OUT_BASE_H

#include <Pacpus/kernel/ConnectionBase.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/kernel/PacpusEvent.h>

#include <QApplication>
#include <QList>
#include <QString>
#include <QStringList>
#include <typeinfo>

namespace pacpus {

class ComponentBase;

class PACPUSLIB_API AbstractInterface
    : public QObject
{
     Q_OBJECT

protected:
    AbstractInterface(QString name, ComponentBase * component, QObject * parent = 0);
    virtual ~AbstractInterface();

public:
    QString getSignature() const;
    QString getName() const;
    virtual QString getDataType() = 0;
    
    void addConnection(ConnectionBase connection);
    bool removeConnection(ConnectionBase connection);
    bool hasConnection();
    
protected:
    QList<ConnectionBase> & connections();
    const QList<ConnectionBase> & getConnections() const;

    ComponentBase * component();
    const ComponentBase * getComponent() const;
    
private:
    QString m_name;
    ComponentBase * m_component;
    QList<ConnectionBase> m_connections;
};

class PACPUSLIB_API InputInterfaceBase
    : public AbstractInterface
{
    Q_OBJECT

protected:
    // TODO: add ctor with function pointer
    InputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0);

public:
    enum ReadingMode {
        NeverSkip,
        TimeBounded,
        GetLast
    };

    virtual ~InputInterfaceBase();

    virtual void customEvent(QEvent * e);

    ReadingMode & readingMode();
    const ReadingMode & getReadingMode() const;
    void setReadingMode(ReadingMode mode);

    virtual PacpusEvent * getEventTemplate();
    
private:
    ReadingMode m_readingMode;

    // metode(QByteArray)
    //QQueue jobQueue_;
};

class PACPUSLIB_API OutputInterfaceBase
    : public AbstractInterface
{
    Q_OBJECT

public:
    OutputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0)
        : AbstractInterface(name, component, parent)
    {}

    virtual ~OutputInterfaceBase()
    {}

    QStringList getInputConnectedList();

    void send(/*const*/ QByteArray & data);
};

} // namespace pacpus

#endif // IN_OUT_BASE_H
