// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    March, 2012
/// @version $Id: Log.h 73 2013-01-10 16:56:42Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Logging facility.
///
/// Detailed description.

#ifndef DEF_PACPUS_LOG_H
#define DEF_PACPUS_LOG_H

#include <Pacpus/kernel/PacpusLibConfig.h>

namespace pacpus {

/// Static log facility initializer
///
/// Uses Schwarz counter (nifty counter) idiom to initialize the log before
/// other static objects that could use the log.
static class PACPUSLIB_API LogConfigurator
{
public:
    LogConfigurator();
    ~LogConfigurator();
    static void configureLoggerWithFile(const char * configFilename);
} logInitializer;

} // namespace pacpus

#if defined(PACPUS_USE_LOG)
#   include <boost/log/attributes/named_scope.hpp>
#   include <boost/log/trivial.hpp>
#   include <iosfwd>

class QString;
template< typename CharT, typename TraitsT >
PACPUSLIB_API std::basic_ostream< CharT, TraitsT >& operator<< (std::basic_ostream< CharT, TraitsT >& strm, QString const& s);

#   define DECLARE_STATIC_LOGGER(name)        //BOOST_LOG_NAMED_SCOPE(name)
#   define PACPUS_LOG_FUNCTION()              BOOST_LOG_FUNCTION()
#   define PACPUS_LOG_NAMED_SCOPE(name)       BOOST_LOG_NAMED_SCOPE(name)
#   define PACPUS_LOG(level, message)         BOOST_LOG_TRIVIAL(level) << message
#else
/// @param name Name of the logger, displayed when logging a message.
#   define DECLARE_STATIC_LOGGER(name)
#   define PACPUS_LOG_FUNCTION()              ((void) 0)
#   define PACPUS_LOG_NAMED_SCOPE(name)       ((void) 0)
#   define PACPUS_LOG(level, message)         ((void) 0)
#endif // PACPUS_USE_LOG

/// Logs a message at TRACE level using default logger
#define LOG_TRACE(message)          PACPUS_LOG(trace, message)
/// Logs a message at DEBUG level using default logger
#define LOG_DEBUG(message)          PACPUS_LOG(debug, message)
/// Logs a message at INFO level using default logger
#define LOG_INFO(message)           PACPUS_LOG(info, message)
/// Logs a message at WARN level using default logger
#define LOG_WARN(message)           PACPUS_LOG(warning, message)
/// Logs a message at ERROR level using default logger
#define LOG_ERROR(message)          PACPUS_LOG(error, message)
/// Logs a message at FATAL level using default logger
#define LOG_FATAL(message)          PACPUS_LOG(fatal, message)

#endif // DEF_PACPUS_LOG_H
