// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    February, 2006
/// @version $Id: pacpus.h 76 2013-01-10 17:05:10Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_H
#define DEF_PACPUS_H

#include <Pacpus/kernel/road_time.h>

/// @def PACPUS_DEPRECATED(func)
/// Develops to the function or method declaration @b func
/// and marks it as deprecated.

/// @def PACPUS_DEPRECATED_MSG(func, msg)
/// Develops to the function or method declaration @b func
/// and marks it as deprecated with a given comment @b msg.
#ifdef __GNUC__
#   define PACPUS_DEPRECATED(func)              func __attribute__ ((deprecated))
#   define PACPUS_DEPRECATED_MSG(func, msg)     PACPUS_DEPRECATED(func)
#elif defined(_MSC_VER)
#   define PACPUS_DEPRECATED(func)              __declspec(deprecated) func
#   define PACPUS_DEPRECATED_MSG(func, msg)     __declspec(deprecated("was declared deprecated: " msg)) func
#else
#   pragma message("WARNING: You need to implement PACPUS_DEPRECATED for this compiler")
#   define PACPUS_DEPRECATED(func)              func
#   define PACPUS_DEPRECATED_MSG(func, msg)     func
#endif

struct donnees_gps
{
    long  ind_qualite;
    double x, y;
    double lon, lat;
    float a, b, phi, sigma_lat, sigma_lon;
    road_time_t time;
    double alt_msl, d_geoidal;
};

struct donnees_abs_zy
{
    float dArD, dArG;
    float speed;
    road_time_t time;
};

struct donnees_gyro
{
    // les mesures sont prises par rapport au point C
    // position de la centrale inertielle
    // vitesse de lacet (rad.s-1) dans le repère de la masse suspendue
    float psi_s;
    road_time_t time;
};

/// Definition of the structure which will be sent for each positioning
/// requests -> MapMatching.cpp 
struct s_MatchedPosition
{
    int				state;      /* Etat du serveur de position absolue hybridée*/
    double			x_match;	/* Position Matchée         */
    double			y_match;	/*  en x et y				*/
    double			x;			/* Position du véhicule		*/
    double			y;			/*	en x et y				*/
    double			theta;		/* cap (par rapport à l'est) dans le système de la carte */
    double			v;			/* vitesse horizontale par rapport à la terre  */
    unsigned long	ID;			/* ID de la route à laquelle appartient la position matchée */
    road_time_t		time;
    int				way;		/* Sens de la route parcourue 1=W2E, 2=E2W*/
    double			dist;		/* abscisse curviligne par rapport au début de la route */
    double			pxx, pyy, pxy; /* covariance de l'erreur en position absolue*/
    double			ptheta;		/*covariance de l'erreur en cap*/
    double      error; 
    donnees_gyro gyro;  
    donnees_abs_zy odo; 
};

#endif // DEF_PACPUS_H
