#include "Pacpus/kernel/ComponentManager.h"
#include "CanSubscription.h"

#include <QDebug>

using namespace pacpus;

bool CanSubscription::subscribe(const CanDecoderBase* who,  const QList<int>& canId )
{
  qDebug() << subscribers_.isEmpty() << subscribers_.size();

  bool result = true;

  qDebug() << "CAN subscription request"; 
  qDebug() << who; 
  qDebug() << canId;
 
  QListIterator<int> i(canId);
  while (i.hasNext())
  {
    int id = i.next();
   // check if subscription is already present
    if (subscribers_.contains(id, const_cast<CanDecoderBase*>(who)) )
    {
      // the pair is already present in hash! 
      result = false;
    }
    else 
    {
      subscribers_.insert(id, const_cast<CanDecoderBase*>(who));
    }
  }

  qDebug() << "state of CAN subscription";
  qDebug() << subscribers_;

  return result;
}


// return true if the unsubscription of the component to the specified can ID list succeeds, false else
bool CanSubscription::unsubscribe(const CanDecoderBase * who, const QList<int>& canId)
{
  // TODO !! 

  return true;
}



bool CanSubscription::dispatchCanFrame(const TimestampedCanFrame & message)
{
  QListIterator<CanDecoderBase*> it( subscribers_.values(message.frame.id) );
  while (it.hasNext())
  {
    ((CanDecoderBase*)it.next())->setData(message);
  }

  return true;
    
}
   