#ifndef __CANFRAME_H__
#define __CANFRAME_H__

#include <cstddef>

#include "Pacpus/kernel/cstdint.h"
#include "Pacpus/kernel/road_time.h"

/// Basic structure of a CAN frame
struct CanFrame
{
    static const std::size_t MAX_CAN_MSG_LENGTH = 8;

    uint32_t id;
    uint8_t dlc;
    uint8_t data [MAX_CAN_MSG_LENGTH];
};

/// CAN structure with timestamping
struct TimestampedCanFrame
{
    CanFrame frame;
    road_time_t time;
    road_timerange_t timerange;
};

#endif
