// *********************************************************************
//  created:    2008/2/11 - 12:56
//  filename:   CanGateway.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 7239
// 
//  version:    $Id: $
//
//  purpose:    Decoding of the CAN bus
//
// *********************************************************************

#ifndef __CanGateway_h__
#define __CanGateway_h__

#include <fstream>

#include "CanGatewayConfig.h"
#include "CanSubscription.h"

#include "Pacpus/kernel/ComponentBase.h"
#include "Pacpus/kernel/DbiteFile.h"
#include "Win32CanInterface.h"

#define INCOMINGCANFRAMES_SIZE 100

// forward declarations
class QSemaphore; 

namespace pacpus {

class CANGATEWAY_API CanGateway
        : public QThread
        , public ComponentBase
        , public CanSubscription
{
	Q_OBJECT

public:
  CanGateway(QString name); 
  ~CanGateway();

  virtual void startActivity();
  virtual void stopActivity();
  virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 

protected:
  void run(); 


private:
  road_time_t tic_;  
  void tic() { tic_ = road_time(); }
  void toc(char * text) { printf("duration = %d %s\n", (int)(road_time() - tic_), text ); }

  Win32CanInterface canIf_; 
  QSemaphore semaphore_;
  TimestampedCanFrame incomingCanFrames_[INCOMINGCANFRAMES_SIZE];
  
  // Properties
  int channel_;
  int speed_;

  char port_[64];
  char accessMode_[64];

  QString source_;
  
  int counter_;

  // dbt files
  pacpus::DbiteFile rawCanFile_;

};

}

#endif // __CanGateway_h__
