#include "ProducerExample.h"

#include <fstream>
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/InputOutputInterface.h>
#include <Pacpus/kernel/Log.h>

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.cityvip.test.ProducerExample");

/// Construct the factory
static ComponentFactory<ProducerExample> sFactory("ProducerExample");

static const char * outputFileName = "producer.txt";

ProducerExample::ProducerExample(QString name)
    : ComponentBase(name)
{
    LOG_TRACE("constructor(" << name << ")");

    namespace po = boost::program_options;
    
    addParameters()
        ("output-path", po::value<std::string>(&mOutputFileName)->default_value("producer.txt"), "set output file path")
    ;
}

ProducerExample::~ProducerExample()
{
    LOG_TRACE("destructor");
}

ComponentBase::COMPONENT_CONFIGURATION
ProducerExample::configureComponent(XmlComponentConfig /*config*/)
{
    PACPUS_LOG_FUNCTION();

    LOG_INFO("component '" << getName() << "' configured");
    return ComponentBase::CONFIGURED_OK;
}
    
void ProducerExample::addInputs()
{
    // empty: no inputs
}

void ProducerExample::addOutputs()
{
    addOutput<QImage, ProducerExample>("image");
}

void ProducerExample::startActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    start();
    setActive(true);
    setState(MONITOR_OK);
    LOG_INFO("started component '" << getName() << "'");
}

void ProducerExample::stopActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    setActive(false);
    setState(STOPPED);
    LOG_INFO("stopped component '" << getName() << "'");
}

void ProducerExample::run()
{
    unsigned int counter = 1;
    int waitTimeMicros = 150 * 1000;

    std::fstream file(outputFileName, std::ios_base::out | std::ios_base::app);
    if (!file.is_open()) {
        LOG_ERROR("file '" << outputFileName << "' cannot be opened");
    }

    QImage mat(10000, 1000, QImage::Format_RGB32);
    //mat.fill( qRgb(189, 149, 39));

    OutputInterface<QImage, ProducerExample> * imageOutput = 
        getTypedOutput<QImage, ProducerExample>("image");

    while (isActive()) {
        //mat.setPixel(0,0,i);
        LOG_INFO("Sent QImage: "
            << "size = " << mat.size().width()<< " x " << mat.size().height()
            );

        checkedSend(imageOutput, mat);

        LOG_INFO("Sent data=" << counter << ", time=" << road_time());
        file << counter << " " << road_time() << "\n" << std::flush;

        usleep(waitTimeMicros);
        ++counter;
        setState(MONITOR_OK);
    }

    file.close();
}
