/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   PS3remote.h
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Read the dualshock 3 button using bluetooth
//
*********************************************************************/

#ifndef PS3_REMOTE_H
# define PS3_REMOTE_H

# include <QApplication>
# include <QThread>

# include "../Dualshock/controller.h"
# include "../../../pacpusbase/PacpusSocket/PacpusSocket.hpp"

namespace pacpus {

  class PS3remote: public QThread {
        Q_OBJECT

        public:
	    PS3remote();
	    PS3remote(PacpusSocket * socket);
	    ~PS3remote();
	    void run();
	    void stop();
	    void sendCmd(uint16_t Ls, uint16_t Rs, int leftF, int rightF);
	    void mode2();
	    void mode1();
	    void checkMode();
        private:
	    ShMem *shmem;
	    struct dualshockButtons_s * b;
	    QMutex mutex;
	    int quit;
	    PacpusSocket * socket_;
    };

};

#endif
