/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   dualshock.cpp
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Read the dualshock 3 button using bluetooth
//
*********************************************************************/

#include "dualshock.h"

#include "kernel/cstdint.h"
#include "kernel/ComponentFactory.h"
#include "kernel/ComponentManager.h"
#include "kernel/DbiteFileTypes.h"
#include "kernel/Log.h"

using namespace pacpus;
using std::string;

DECLARE_STATIC_LOGGER("pacpus.base.dualshock");

static ComponentFactory<Dualshock> sFactory("Dualshock");

Dualshock::Dualshock(QString name)
    : ComponentBase(name)
{
}

Dualshock::~Dualshock()
{
}

void Dualshock::startActivity()
{
    try {
        d = new(DualshockAPI);
        d->start();
    }
    catch(char const* str) {
        std::cerr << "ERROR: " << str << std::endl;
    }
    std::cerr << "Thread dualshock started\n";
}

void Dualshock::stopActivity()
{
    d->stop();
    std::cerr << "Thread dualshock stopped\n";
}

ComponentBase::COMPONENT_CONFIGURATION Dualshock::configureComponent(XmlComponentConfig config)
{
    return ComponentBase::CONFIGURED_OK;
}
