/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   Wifibot.h
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Control the wifibot with the dualshock 3
//
*********************************************************************/
#ifndef WIFIBOT_API
# define WIFIBOT_API 

#include "ps3remote.h"
#include "Pacpus/kernel/Log.h"
#include "Pacpus/kernel/ComponentBase.h" 
#include "Pacpus/kernel/ComponentFactory.h" 


namespace pacpus {

class WIFIBOT_API Wifibot
        : public QObject
        , public ComponentBase 
{ 
  Q_OBJECT

public: 
    /// Constructor
    Wifibot (QString name);
    /// Destructor
    ~Wifibot();
    
protected:
    // The 3 virtual methods relative to the ComponentBase inheritance
    virtual void startActivity();
    virtual void stopActivity();
    virtual COMPONENT_CONFIGURATION configureComponent (XmlComponentConfig config);
    
private:
    PS3remote * dualshock;
    PacpusSocket * pacpusSocket_;
};

} // namespace pacpus
#endif