/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   PacpusSocket.cpp
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Control the wifibot with the dualshock 3
//
*********************************************************************/

#include "wifibot.h"

using namespace pacpus;


DECLARE_STATIC_LOGGER("pacpus.base.Wifibot");

//////////////////////////////////////////////////////////////////////////
// Construct the factory
//////////////////////////////////////////////////////////////////////////
static ComponentFactory <Wifibot> sFactory("Wifibot");  

//////////////////////////////////////////////////////////////////////////
// C
//////////////////////////////////////////////////////////////////////////
Wifibot::Wifibot(QString name)
    : ComponentBase( name ) 
{
  
} 


//////////////////////////////////////////////////////////////////////////
// Destructor
//////////////////////////////////////////////////////////////////////////
Wifibot::~Wifibot() 
{
  
}

//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to pass the XML parameters to the 
// component 
//////////////////////////////////////////////////////////////////////////
ComponentBase::COMPONENT_CONFIGURATION  Wifibot::configureComponent( XmlComponentConfig config ) 
{ 
    QString pacpusSocket = config.getProperty("socketComponent");
    ComponentManager * mgr = ComponentManager::getInstance();
    pacpusSocket_ = dynamic_cast<PacpusSocket *>(mgr->getComponent(pacpusSocket));
    if (!pacpusSocket_) {
	    qWarning() << "Failed to get component " << pacpusSocket;
	    return ComponentBase::NOT_CONFIGURED;
    }
  
    return ComponentBase::CONFIGURED_OK; 
} 



//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to start the component
//////////////////////////////////////////////////////////////////////////
void Wifibot::startActivity() 
{ 
    dualshock = new PS3remote(pacpusSocket_);
    dualshock->start();
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to stop the component
//////////////////////////////////////////////////////////////////////////
void Wifibot::stopActivity()
{
    dualshock->stop();
}

