/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   controller.cpp
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Read the dualshock 3 button using bluetooth
//
*********************************************************************/

#ifndef CONTROLLER_H
# define CONTROLLER_H

# include <iostream>
# include <stdlib.h>
# include <unistd.h>
# include <sys/socket.h>
# include <bluetooth/bluetooth.h>
# include <bluetooth/l2cap.h>
# include <QApplication>
# include <QThread>

# include "kernel/ComponentBase.h"
# include "kernel/DbiteFile.h"
# include "kernel/DbiteFileTypes.h"
# include "PacpusTools/ShMem.h"

# define L2CAP_PSM_HIDP_CTRL 0x11
# define L2CAP_PSM_HIDP_INTR 0x13

# define HIDP_TRANS_GET_REPORT    0x40
# define HIDP_TRANS_SET_REPORT    0x50
# define HIDP_DATA_RTYPE_INPUT    0x01
# define HIDP_DATA_RTYPE_OUTPUT   0x02
# define HIDP_DATA_RTYPE_FEATURE  0x03

namespace pacpus {

    struct buttons_s {
        struct {
            uint8_t
                leftStick_x,
                leftStick_y,
                rightStick_x,
                rightStick_y;
        } stick;

        struct {
            uint8_t
                select:1,
                l3:1,
                r3:1,
                start:1,
                up:1,
                right:1,
                down:1,
                left:1,
                l2:1,
                r2:1,
                l1:1,
                r1:1,
                triangle:1,
                circle:1,
                cross:1,
                square:1;
        } digital;

        struct {
            uint8_t l1;
            uint8_t l2;
            uint8_t r1;
            uint8_t r2;
            uint8_t triangle;
            uint8_t circle;
            uint8_t cross;
            uint8_t square;
            uint8_t up;
            uint8_t right;
            uint8_t down;
            uint8_t left;
        } analog;

        struct {
            int8_t x;
            int8_t y;
            int8_t z;
            int8_t gZ;
        } axis;
    };

    class Controller {
        public:
            struct buttons_s buttons;
            bdaddr_t addr;
            int csk;
            int isk;
            int paired;
	    int timeout;
            unsigned index;
    };

    struct dualshockButtons_s {
        road_time_t       time;
        struct buttons_s  buttons;
        int               available;
	int               timeout;
    };

    class DualshockAPI: public QThread {
        Q_OBJECT

        public:
            DualshockAPI();
            ~DualshockAPI();
            void run();
            void stop();

        private:
            void main_loop();
            int l2cap_listen(const bdaddr_t *bdaddr, unsigned short psm);
            void handle_connection();
            void handle_disconnection();
            void setup_device(int sk);
            void handle_report(unsigned char buf[], int len);
            void update_shared_memory();

            Controller controller;
            ShMem *shmem;
            DbiteFile dbtFile;
            int csk;
            int isk;
            int quit;
    };
}
#endif /* CONTROLLER_H */
