// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @author  Elie Al Alam <firstname.surname@utc.fr>
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    April, 2007
/// @version $Id: main.cpp 81 2013-01-11 22:31:02Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief DbitePlayer main function.
///
/// Detailed description.
/// @todo        - barre de temps dans l'affichage graphique
///              - am�liorer l'affichage ; ic�ne, emplacement des boutons...
///              - ajouter r�pertoire racine des donn�es (fait) :
///              ajouter affichage de ce r�pertoire
///              - ajouter classe g�n�rique d'�change de donn�es vers
///              d'autres applications
///              - fen�tre de monitoring des composants : valable pour
///              toutes les applis bas�es sur PacpusLib
///              avec possibilit� de masquer cette partie
///              - faire une classe GraphViewer :
///              permet d'afficher un nombre ind�fini de courbes
///              offre des param�tres basiques : couleurs de la courbe,
///              types de points, reli�s ou pas
///              les courbes sont identifi�s par des noms
///              voir comment l'utilisateur peut interagir avec les courbes
///              par ex recuperer la valeur d'un point
///              - associer a chaque composant une fenetre en dock view,
///              affichagable ou pas defini dans le fichier de config

#include <Pacpus/DbitePlayer/DbtPlyEngine.h>
#include <Pacpus/DbitePlayer/DbtPlyTrigger.h>
#include <Pacpus/DbitePlayer/DbtPlyUserInterface.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/PacpusApplication.h>
#include <Pacpus/kernel/PacpusException.h>
#include <Pacpus/kernel/PacpusPluginInterface.h>

#include <boost/assert.hpp>
#include <boost/cstdlib.hpp>

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.core.DbitePlayer");

static const string kDefaultXmlConfigFilePath = "DbitePlayer.xml";

int main(int argc, char * argv[])
{
    LogConfigurator::configureLoggerWithFile("PacpusDbitePlayer_%N.log");

    PacpusApplication app(argc, argv);
    ComponentManager * mgr = ComponentManager::getInstance();

    static ComponentFactory<DbtPlyEngine> factoryDbtPlyEngine("DbtPlyEngine");
    (void) factoryDbtPlyEngine; // unused
    static ComponentFactory<DbtPlyTrigger> factoryDbtPlyTrigger("DbtPlyTrigger");
    (void) factoryDbtPlyTrigger; // unused
    static ComponentFactory<DbtPlyUserInterface> factoryDbtPlyUserInterface("DbtPlyUserInterface");
    (void) factoryDbtPlyUserInterface; // unused

    string configFilePath;
    if (argc > 1) {
        configFilePath = argv[1];
    } else {
        configFilePath = kDefaultXmlConfigFilePath;
        LOG_WARN("no XML config file specified. Using default: " << configFilePath);
    }
    LOG_INFO("loading file '" << configFilePath << "'");
    const size_t componentCount = mgr->loadComponents(configFilePath.c_str());
    if (componentCount == 0) {
        LOG_FATAL("no components, exiting");
        return EXIT_FAILURE;
    }

    int exitStatus;
    try {
        // start all the components (engine, trigger, user interface and the DBT file managers)
        mgr->start();
        // save application exit status
        exitStatus = app.exec();
        // stop all components before exiting app
        mgr->stop();

        mgr->destroy();
    } catch (PacpusException& e) {
        LOG_WARN("Pacpus exception caught: " << e.what());
        exitStatus = boost::exit_exception_failure;
    }

    // return application exit status
    return exitStatus;
}
