#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

# TODO: write the output variables of this CMake file.

# Locate the include files
set(PACPUS_INCLUDE_HINTS
    "${PACPUS_ROOT}/include"
    "$ENV{PACPUS_ROOT}/include"
)
if(WIN32)
    list(APPEND PACPUS_INCLUDE_HINTS
        "C:/Program Files/Pacpus/include"
        "C:/Program Files (x86)/Pacpus/include"
        "C:/Pacpus/include"
        "C:/lib/Pacpus/include"
        "D:/Program Files/Pacpus/include"
        "D:/Program Files (x86)/Pacpus/include"
        "D:/Pacpus/include"
        "D:/lib/Pacpus/include"
    )
else()
    # TODO: add default paths no Unix-like systems
    list(APPEND PACPUS_INCLUDE_HINTS
    )
endif()
find_path(PACPUS_INCLUDE_DIR
    NAMES "Pacpus/kernel/pacpus.h"
    HINTS ${PACPUS_INCLUDE_HINTS}
    DOC "The Pacpus include directory"
)

if(NOT PACPUS_INCLUDE_DIR)
    message(FATAL_ERROR "Could not find PACPUS. Please set CMake variable PACPUS_ROOT or environment variable PACPUS_ROOT.")
endif()

get_filename_component(PACPUS_ROOT ${PACPUS_INCLUDE_DIR}/.. ABSOLUTE)
set(PACPUS_LIB_DIR ${PACPUS_ROOT}/lib)

# List of required modules
set(PACPUS_MODULES "FileLib" "PacpusLib" "PacpusTools" "dbiteplayerlib")
if(WIN32)
    list(APPEND PACPUS_MODULES "ROAD_TIME")
endif()

set(MODULE_MISSING FALSE)
set(PACPUS_LIBRARIES "")

# Check the presence of each module
foreach(module ${PACPUS_MODULES})
    # release version
    find_library(
        PACPUS_${module}_LIB
        NAMES ${module}
        HINTS ${PACPUS_LIB_DIR}
    )
    if(PACPUS_${module}_LIB)
        list(APPEND PACPUS_LIBRARIES optimized ${PACPUS_${module}_LIB})
    else()
        message(SEND_ERROR "Cannot find Pacpus module ${module} (release version)")
        set(MODULE_MISSING TRUE)
    endif()
    
    # debug version
    find_library(
        PACPUS_${module}_LIBD
        NAMES ${module}_d
        HINTS ${PACPUS_LIB_DIR}
    )
    if(PACPUS_${module}_LIBD)
        list(APPEND PACPUS_LIBRARIES debug ${PACPUS_${module}_LIBD})
    else()
        message(SEND_ERROR "Cannot find Pacpus module ${module}_d (debug version)")
        set(MODULE_MISSING TRUE)
    endif()
endforeach()

# handle the QUIETLY and REQUIRED arguments and set PACPUS_FOUND to TRUE if
# all listed variables are TRUE
include (FindPackageHandleStandardArgs)
set(PACPUS_ALL_MODULES_FOUND NOT MODULE_MISSING)
find_package_handle_standard_args (PACPUS DEFAULT_MSG PACPUS_LIBRARIES PACPUS_INCLUDE_DIR PACPUS_ALL_MODULES_FOUND)

if(PACPUS_FOUND)
    set(PACPUS_INSTALL_DIR ${PACPUS_ROOT})
    set(PACPUS_CMAKE_DIR ${PACPUS_ROOT}/cmake)
    set(CMAKE_INSTALL_PREFIX ${PACPUS_INSTALL_DIR})
    list(APPEND CMAKE_PREFIX_PATH ${PACPUS_CMAKE_DIR})
    list(APPEND CMAKE_MODULE_PATH "${PACPUS_CMAKE_DIR}")
    
    include(${PACPUS_CMAKE_DIR}/PacpusUtilities.cmake)
    include(${PACPUS_CMAKE_DIR}/PacpusConfiguration.cmake)
    include(${PACPUS_CMAKE_DIR}/PacpusDependencies.cmake)
    include(${PACPUS_CMAKE_DIR}/PacpusPlatforms.cmake)
endif()
