#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

## ========================================
## Qt macro compatibility Qt4 / Qt5
## ========================================
function(qt_wrap_cpp OUT_MOC_SRCS)
    set(FILES_TO_MOC ${ARGN})
    if(QT4_FOUND)
        qt4_wrap_cpp(MOC_SRCS ${FILES_TO_MOC}
            OPTIONS -DBOOST_TT_HAS_OPERATOR_HPP_INCLUDED -DBOOST_NO_TEMPLATE_PARTIAL_SPECIALIZATION # fixes QTBUG-22829
        )
    elseif(Qt5Core_FOUND)
        qt5_wrap_cpp(MOC_SRCS ${FILES_TO_MOC})
    else()
        message(WARNING "QT not found, cannot wrap moc files")
    endif()

    set(${OUT_MOC_SRCS} ${MOC_SRCS} PARENT_SCOPE)
endfunction(qt_wrap_cpp)

## ========================================
## Qt macro compatibility Qt4 / Qt5
## ========================================
function(qt_wrap_ui OUT_UI_SRCS)
    set(UI_FILES ${ARGN})
    if(QT4_FOUND)
        qt4_wrap_ui( UI_SRCS ${UI_FILES})
    elseif(Qt5Core_FOUND)
        qt5_wrap_ui( UI_SRCS ${UI_FILES})
    else()
        message(WARNING "QT not found, cannot wrap ui files")
    endif()

    set(${OUT_UI_SRCS} ${UI_SRCS} PARENT_SCOPE)
endfunction()

## ========================================
## Qt macro compatibility Qt4 / Qt5
## ========================================
function(qt_add_resources OUT_RESOURCES)
    set(RCS_FILES ${ARGN})
    if(QT4_FOUND)
        qt4_add_resources( RESOURCES ${RCS_FILES})
    elseif(Qt5Core_FOUND)
        qt5_add_resources( RESOURCES ${RCS_FILES})
    else()
        message(WARNING "QT not found, cannot add resources")
    endif()

    set(${OUT_RESOURCES} ${RESOURCES} PARENT_SCOPE)
endfunction()

# ========================================
# Generic macro for Pacpus plugin
# ========================================
function(PACPUS_PLUGIN OUT_CPP OUT_H PLUGIN_NAME)
    if(QT4_FOUND)
        pacpus_plugin_qt4(PLUGIN_CPP PLUGIN_H ${PROJECT_NAME} )
    elseif(Qt5Core_FOUND)
        pacpus_plugin_qt5(PLUGIN_CPP PLUGIN_H ${PROJECT_NAME} )
    else()
        message(WARNING "QT not found, can't create Plugin")
    endif()

    set(${OUT_CPP} ${PLUGIN_CPP} PARENT_SCOPE)
    set(${OUT_H} ${PLUGIN_H} PARENT_SCOPE)
endfunction(PACPUS_PLUGIN)

# ========================================
# Create a Pacpus plugin QT4
# ========================================
function(PACPUS_PLUGIN_QT4 OUT_CPP OUT_H PLUGIN_NAME)
    set(PLUGIN_NAME ${PLUGIN_NAME}Plugin)
    set(${OUT_CPP} ${PLUGIN_NAME}.cpp PARENT_SCOPE)
    set(${OUT_H} ${PLUGIN_NAME}.h PARENT_SCOPE)

    string(TOUPPER ${PLUGIN_NAME} PLUGIN_NAME_UPPER)

    # create the header file
    file(WRITE ${PLUGIN_NAME}.h
        "// Autogenerated file by PacpusPlugin.cmake\n"
        "// DO NOT EDIT!!! ALL CHANGES WOULD BE REMOVED BY THE NEXT CALL OF CMAKE\n"
        "\n"
        "#ifndef __${PLUGIN_NAME_UPPER}_H__\n"
        "#define __${PLUGIN_NAME_UPPER}_H__\n"
        "\n"
        "#include <QObject>\n"
        "#include <qplugin.h>\n"
        "\n"
        "#include <Pacpus/kernel/PacpusPluginInterface.h>\n"
        "\n"
        "/// Auto-generated plugin class\n"
        "class ${PLUGIN_NAME}\n"
        "    : public QObject\n"
        "    , public PacpusPluginInterface\n"
        "{\n"
        "    Q_OBJECT\n"
        "    Q_INTERFACES(PacpusPluginInterface)\n"
        "\n"
        "public:\n"
        "    ${PLUGIN_NAME}();\n"
        "    ~${PLUGIN_NAME}();\n"
        "\n"
        "protected:\n"
        "    QString name();\n"
        "};\n"
        "\n"
        "#endif // __${PLUGIN_NAME_UPPER}_H__\n"
    )

    # create the cpp file
    file(WRITE ${PLUGIN_NAME}.cpp
        "// Autogenerated file by PacpusPlugin.cmake\n"
        "// DO NOT EDIT!!! ALL CHANGES WOULD BE REMOVED BY THE NEXT CALL OF CMAKE\n"
        "\n"
        "#include \"${PLUGIN_NAME}.h\"\n"
        "\n"
        "${PLUGIN_NAME}::${PLUGIN_NAME}()\n"
        "{\n"
        "}\n"
        "\n"
        "${PLUGIN_NAME}::~${PLUGIN_NAME}()\n"
        "{\n"
        "}\n"
        "\n"
        "QString ${PLUGIN_NAME}::name()\n"
        "{\n"
        "    return \"${PLUGIN_NAME}\";\n"
        "}\n"
        "\n"
        "Q_EXPORT_PLUGIN2(${PLUGIN_NAME}, ${PLUGIN_NAME})\n"
    )
endfunction(PACPUS_PLUGIN_QT4)

# ========================================
# Create a Pacpus plugin QT5
# ========================================
function(PACPUS_PLUGIN_QT5 OUT_CPP OUT_H PLUGIN_NAME)
    set(PLUGIN_NAME ${PLUGIN_NAME}Plugin)
    set(${OUT_CPP} ${PLUGIN_NAME}.cpp ${PLUGIN_NAME}.json PARENT_SCOPE)
    set(${OUT_H} ${PLUGIN_NAME}.h PARENT_SCOPE)

    string(TOUPPER ${PLUGIN_NAME} PLUGIN_NAME_UPPER)

    # create the header file
    file(WRITE ${PLUGIN_NAME}.h
        "// Autogenerated file by PacpusUtilities.cmake\n"
        "// DO NOT EDIT!!! ALL CHANGES WOULD BE REMOVED BY THE NEXT CALL OF CMAKE\n"
        "\n"
        "#ifndef __${PLUGIN_NAME_UPPER}_H__\n"
        "#define __${PLUGIN_NAME_UPPER}_H__\n"
        "\n"
        "#include <QObject>\n"
        "#include <qplugin.h>\n"
        "\n"
        "#include <Pacpus/kernel/PacpusPluginInterface.h>\n"
        "\n"
        "/// Auto-generated plugin class\n"
        "class ${PLUGIN_NAME}\n"
        "    : public QObject\n"
        "    , public PacpusPluginInterface\n"
        "{\n"
        "    Q_OBJECT\n"
        "    //Qt5 Plugins Macro\n"
        "    Q_PLUGIN_METADATA(IID \"pacpus." ${PLUGIN_NAME} "\" FILE \"" ${PLUGIN_NAME} ".json\")\n"
        "    Q_INTERFACES(PacpusPluginInterface)\n"    
        "\n"
        "public:\n"
        "    ${PLUGIN_NAME}();\n"
        "    ~${PLUGIN_NAME}();\n" 
        "\n"
        "protected:\n"
        "    QString name();\n"
        "};\n"
        "\n"
        "#endif // __${PLUGIN_NAME_UPPER}_H__\n"
    )

    # create the cpp file
    file(WRITE ${PLUGIN_NAME}.cpp
        "// Autogenerated file by PacpusUtilities.cmake\n"
        "// DO NOT EDIT!!! ALL CHANGES WOULD BE REMOVED BY THE NEXT CALL OF CMAKE\n"
        "\n"
        "#include \"${PLUGIN_NAME}.h\"\n"
        "\n"
        "${PLUGIN_NAME}::${PLUGIN_NAME}()\n"
        "{\n"
        "}\n"
        "\n"
        "${PLUGIN_NAME}::~${PLUGIN_NAME}()\n"
        "{\n"
        "}\n"
        "\n"
        "QString ${PLUGIN_NAME}::name()\n"
        "{\n"
        "    return \"${PLUGIN_NAME}\";\n"
        "}\n"
        "\n"
        "//Qt4 Plugin Macro desactivated\n"
        "//Q_EXPORT_PLUGIN2(${PLUGIN_NAME}, ${PLUGIN_NAME})\n"
    )

    file(WRITE ${PLUGIN_NAME}.json
        "{\n"
        "    \"Keys\": [\"${PLUGIN_NAME}\"]\n"
        "}\n"
    )
endfunction(PACPUS_PLUGIN_QT5)

# ========================================
# Replace backslashes by slashes
# ========================================
macro(pacpus_purge_backslash var)
    string(REGEX REPLACE "\\\\" "/" ${var} "${${var}}")
endmacro()

# ========================================
# Get the version of MSVC as a string
# ========================================
macro(pacpus_get_msvc output)
    # By default, unknown
    set(${output} "unknown")
    if(MSVC9)
        set(${output} "msvc2008")
    elseif(MSVC10)
        set(${output} "msvc2010")
    else(MSVC11)
        set(${output} "msvc2012")
    endif()
endmacro()

# ========================================
# Print a debug message
# ========================================
function(pacpus_output_status msg)
    message(STATUS "${msg}")
    string(REPLACE "\\" "\\\\" msg "${msg}")
    string(REPLACE "\"" "\\\"" msg "${msg}")
endfunction()

# ========================================
# Pacpus log message
# ========================================
function(pacpus_info text)
    set(status_cond)
    set(status_then)
    set(status_else)

    set(status_current_name "cond")
    foreach(arg ${ARGN})
        if(arg STREQUAL "THEN")
            set(status_current_name "then")
        elseif(arg STREQUAL "ELSE")
            set(status_current_name "else")
        else()
            list(APPEND status_${status_current_name} ${arg})
        endif()
    endforeach()

    if(DEFINED status_cond)
        set(status_placeholder_length 32)
        string(RANDOM LENGTH ${status_placeholder_length} ALPHABET " " status_placeholder)
        string(LENGTH "${text}" status_text_length)
        if(status_text_length LESS status_placeholder_length)
            string(SUBSTRING "${text}${status_placeholder}" 0 ${status_placeholder_length} status_text)
        elseif(DEFINED status_then OR DEFINED status_else)
            pacpus_output_status("${text}")
            set(status_text "${status_placeholder}")
        else()
            set(status_text "${text}")
        endif()

        if(DEFINED status_then OR DEFINED status_else)
            if(${status_cond})
                string(REPLACE ";" " " status_then "${status_then}")
                string(REGEX REPLACE "^[ \t]+" "" status_then "${status_then}")
                pacpus_output_status("${status_text} ${status_then}")
            else()
                string(REPLACE ";" " " status_else "${status_else}")
                string(REGEX REPLACE "^[ \t]+" "" status_else "${status_else}")
                pacpus_output_status("${status_text} ${status_else}")
            endif()
        else()
            string(REPLACE ";" " " status_cond "${status_cond}")
            string(REGEX REPLACE "^[ \t]+" "" status_cond "${status_cond}")
            pacpus_output_status("${status_text} ${status_cond}")
        endif()
    else()
        pacpus_output_status("${text}")
    endif()
endfunction()

# ========================================
# Pacpus add library and set debug postfix
# ========================================
function(pacpus_add_library target)
    add_library(
        ${ARGV}
    )
    set_target_properties(
        ${target}
        PROPERTIES DEBUG_POSTFIX "_d"
    )
	# Add manifest to the target (Windows SxS)
	# TODO: do the same for executable (change #2 to #1)
	#if(MSVC)
	#	pacpus_info("\${CMAKE_CURRENT_SOURCE_DIR}/\${target}.manifest = ${CMAKE_CURRENT_SOURCE_DIR}/${target}.manifest")
	#	if(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}\\${target}.manifest")
	#		pacpus_info("Exists: ${CMAKE_CURRENT_SOURCE_DIR}/${target}.manifest")
	#		add_custom_command(
	#			TARGET ${target}
	#			POST_BUILD
	#			COMMAND "mt.exe" -manifest \"${CMAKE_CURRENT_SOURCE_DIR}\\${target}.manifest\" -outputresource:\"$(TargetDir)\\$(TargetFileName)\"\;\#2
	#			COMMENT "Adding custom manifest containing MSVCRT80 dependency..." 
	#		)
	#	endif()
	#endif()
endfunction()

# ========================================
# Pacpus add executable and set debug postfix
# ========================================
function(pacpus_add_executable target)
    add_executable(
        ${ARGV}
    )
    set_target_properties(
        ${target}
        PROPERTIES DEBUG_POSTFIX "_d"
    )
endfunction()

# ========================================
# Pacpus install
# ========================================
function(pacpus_install)
    install(
        TARGETS ${ARGV}
        RUNTIME DESTINATION ${PACPUS_INSTALL_DIR}/bin
        LIBRARY DESTINATION ${PACPUS_INSTALL_DIR}/bin
        ARCHIVE DESTINATION ${PACPUS_INSTALL_DIR}/lib
    )
    if(MSVC)
        # install debug information files .pdb
        foreach(target ${ARGV})
            get_target_property(target_filepath ${target} LOCATION_DEBUG)
            get_filename_component(target_directory ${target_filepath} PATH)
            get_filename_component(target_basename ${target_filepath} NAME_WE)
            
            set(target_pdb "${target_directory}/${target_basename}.pdb")
            install(FILES ${target_pdb}
                CONFIGURATIONS Debug
                DESTINATION ${PACPUS_INSTALL_DIR}/lib
            )
        endforeach()
    endif(MSVC)
endfunction()

# ========================================
# Pacpus folder
# ========================================
function(pacpus_folder target folder_name)
    if(PACPUS_USE_SOLUTION_FOLDERS AND MSVC)
        set_target_properties(${target}
            PROPERTIES FOLDER ${folder_name}
        )
    endif()
endfunction()

# ========================================
# Get sub directories
# ========================================
MACRO(SUBDIRLIST result curdir)
  FILE(GLOB children RELATIVE ${curdir} ${curdir}/*)
  SET(dirlist "")
  FOREACH(child ${children})
    IF(IS_DIRECTORY ${curdir}/${child})
        SET(dirlist ${dirlist} ${child})
    ENDIF()
  ENDFOREACH()
  SET(${result} ${dirlist})
ENDMACRO()


# ========================================
# Create export header for plugins
#
# Usage: `create_export(PluginExportHeader "MyPluginName")`
#
# DLL export/import will depend on macro `${PLUGIN_NAME_UPPER}_EXPORTS`
# which can be set using `add_definitions( -D${PLUGIN_NAME_UPPER}_EXPORTS )`
# ========================================
function(CREATE_EXPORT OUT_H PLUGIN_NAME)
    # set output directory if given, otherwise use current directory
    set(PLUGIN_OUTPUT_DIR "${ARGN}")
    # set file name to the input variable
    set(PLUGIN_CONFIG_FILE "${PLUGIN_NAME}Config.h")
    if (NOT "${PLUGIN_OUTPUT_DIR}" STREQUAL "")
        set(PLUGIN_CONFIG_FILE "${PLUGIN_OUTPUT_DIR}/${PLUGIN_CONFIG_FILE}")
    endif()
    
    set(${OUT_H} "${PLUGIN_CONFIG_FILE}" PARENT_SCOPE)
    
    string(TOUPPER ${PLUGIN_NAME} PLUGIN_NAME_UPPER)
    add_definitions( -D${PLUGIN_NAME_UPPER}_EXPORTS )
    
    # create the header file
    file(WRITE "${PLUGIN_CONFIG_FILE}"
        "// Autogenerated file by PacpusUtilities.cmake\n"
        "// DO NOT EDIT!!! ALL CHANGES WOULD BE REMOVED BY THE NEXT CALL OF CMAKE\n"
        "\n"

        "#ifndef __${PLUGIN_NAME_UPPER}_CONFIG_H__\n"
        "#define __${PLUGIN_NAME_UPPER}_CONFIG_H__\n"
        "\n"
        "// Export macro for use DLL for Windows only\n"
        "#ifdef WIN32\n"
        "   #ifdef ${PLUGIN_NAME_UPPER}_EXPORTS\n"
        "//      make DLL\n"
        "       #define ${PLUGIN_NAME_UPPER}_API __declspec(dllexport)\n"
        "   #else\n"
        "//      use DLL\n"
        "       #define ${PLUGIN_NAME_UPPER}_API __declspec(dllimport)\n"
        "   #endif\n"
        "#else\n"
        "//      On other platforms, simply ignore this\n"
        "   #define ${PLUGIN_NAME_UPPER}_API\n"
        "#endif\n\n"

        "#endif // __${PLUGIN_NAME_UPPER}_CONFIG_H__\n"
        )
endfunction(CREATE_EXPORT)
