#include "ConsumerExample.h"

#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/InputOutputInterface.h>

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.cityvip.test.ConsumerExample");

/// Construct the factory
static ComponentFactory<ConsumerExample> sFactory("ConsumerExample");

ConsumerExample::ConsumerExample(QString name)
    : ComponentBase(name)
{
    LOG_TRACE("constructor(" << name << ")");

    LOG_INFO("Thread " << thread.currentThread());
    LOG_INFO("Current Thread " << QThread::currentThread());

    namespace po = boost::program_options;
    addParameters()
        ("output-path", po::value<std::string>(&mOutputFileName)->default_value("consumer.txt"), "set output file path")
    ;
}

ConsumerExample::~ConsumerExample()
{
    LOG_TRACE("destructor");
}

void ConsumerExample::addInputs()
{
    addInput<QImage, ConsumerExample>("image", &ConsumerExample::process);
}

void ConsumerExample::addOutputs()
{
    // empty: no outputs
}

ComponentBase::COMPONENT_CONFIGURATION
ConsumerExample::configureComponent(XmlComponentConfig /*config*/)
{
    PACPUS_LOG_FUNCTION();

    // load XML parameters -- NOT NEEDED - loaded by boost::program_options (used addParameters())

    LOG_INFO("component '" << getName() << "' configured");
    return ComponentBase::CONFIGURED_OK;
}

void ConsumerExample::startActivity()
{
    LOG_TRACE(Q_FUNC_INFO);
    moveToThread(&thread);
    m_counter = 0;
    
    m_file.open(mOutputFileName.c_str(), std::ios_base::out | std::ios_base::app);
    if (!m_file.is_open()) {
        LOG_ERROR("file '" << mOutputFileName << "' cannot be opened");
    }

    thread.start();
    setState(MONITOR_OK);
    LOG_INFO("started component '" << getName() << "'");
}

void ConsumerExample::stopActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    QMetaObject::invokeMethod(&thread, "quit");
    m_file.close();
    setState(STOPPED);
    LOG_INFO("stopped component '" << getName() << "'");
}

void ConsumerExample::process(const QImage& matrix)
{
    m_file << ++m_counter << " " << road_time() << "\n" << std::flush;

    LOG_INFO("Received QIMage: "
        << "size = " << matrix.size().width()<< " x " << matrix.size().height()
        );

    // DO PROCESSING

    setState(MONITOR_OK);
}

void testPacpusTypedEventConverts()
{
    PacpusTypedEvent<float> floatEvent(TYPED_EVENT, 1.0f);
    PacpusTypedEvent<double> doubleEvent = floatEvent;
    
    PacpusTypedEvent<int> intEvent(TYPED_EVENT, 2);
    //PacpusTypedEvent<QImage> imageEvent = intEvent;
}
