// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @date    January, 2006
/// @version $Id: XmlConfigFile.h 76 2013-01-10 17:05:10Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Purpose:    Classe permettant d'enregistrer un fichier de 
///             configuration XML
///             Le fichier XML contient 2 sections : 
///             - parameters : contient les parametres de l'application 
///             - components : contient les composants
///             les composants ne peuvent pas avoir de noeuds fils
///
/// @todo       Creer une dtd qui permet de definir la liste des classes possibles
///             que peuvent prendre les composants 

#ifndef DEF_PACPUS_XMLCONFIGFILE_H
#define DEF_PACPUS_XMLCONFIGFILE_H

#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/kernel/PacpusLibConfig.h>
#include <Pacpus/kernel/XmlComponentConfig.h>

#include <QDomElement>
#include <QFile>
#include <QMutex>
#include <QStringList>

class QFile;

namespace pacpus {

/// XML config properties:
///     list            STRING(S)   name(s) of plugin files to be loaded, separated by pipe symbol '|'
///         e.g. dbt="libDbtPlyGps.so|libDbtPlyVision.so
class PACPUSLIB_API XmlConfigFile
{
    friend XmlComponentConfig::XmlComponentConfig(QString const&);
    friend class ComponentManager;

public:
    /// @todo Documentation
    static XmlConfigFile * create();
    /// @todo Documentation
    static void destroy();

    /// @returns a list of all names of components declared in the XML tree
    QStringList getAllComponentsNames() const;
    /// @todo Documentation
    QDomElement getComponent(QString name) const;
    
    // TODO: QStringList getAllConnectionsNames() const;
    QDomElement getConnection(QString connectionName) const;

    /// @todo Documentation
    QStringList getAllPluginsNames();
    
    /// @todo Documentation
    int loadFile(QString fileName);

    /// @todo Documentation
    /// not used
    void saveFile(QString fileName);
    
    /// @todo Documentation
    /// not used
    void addComponent(QDomElement component);
    
    /// @todo Documentation
    /// @deprecated Use removeComponent()
    /// not used
    PACPUS_DEPRECATED_MSG( void delComponent(QDomElement component), "use removeComponent()" );
    void removeComponent(QDomElement component);

protected:
    QDomElement getSection(const char * name) const;
    QDomNodeList getNodesInSection(const char * sectionName, const char * nodeName) const;

    QDomNodeList getAllComponents() const;
    QDomNodeList getAllConnections() const;
    QDomNodeList getAllParameters() const;
    QDomNodeList getAllPlugins();

private:
    XmlConfigFile();
    ~XmlConfigFile();

    QDomElement createComponent(QString name);

    QString libraryExtension() const;
    QString libraryPrefix() const;
    QString libraryPostfix() const;

private:
    static XmlConfigFile * m_xmlConfigFile;
    
    QDomDocument m_document;
    QFile m_file;
    QMutex m_mutex;

    QString m_libraryExtension;
    QString m_libraryPrefix;
    QString m_libraryPostfix;
    
    int m_numberOfComponents;
};

} // namespace pacpus

#endif // DEF_PACPUS_XMLCONFIGFILE_H
