// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @version    $Id: ComponentFactoryBase.cpp 76 2013-01-10 17:05:10Z kurdejma $

#include <Pacpus/kernel/ComponentFactoryBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/Log.h>

#include <boost/assert.hpp>
#include <QString>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.ComponentFactoryBase");

ComponentFactoryBase::ComponentFactoryBase()
    : mgr_(NULL)
{
    LOG_TRACE("constructor");
    // get the adress of the ComponentManager instance
    mgr_ = ComponentManager::getInstance();
    BOOST_ASSERT(mgr_);
}

ComponentFactoryBase::~ComponentFactoryBase()
{
    LOG_TRACE("destructor");
}

void ComponentFactoryBase::addFactory(ComponentFactoryBase* addr, QString const& type)
{
    LOG_DEBUG("addFactory(type="<< type << ")");

    if (!mgr_->registerComponentFactory(addr, type)) {
        /*
        // FIXME: delete in a secure manner (no double delete)
        delete addr;
        addr = NULL;
        */
    }
}

void ComponentFactoryBase::createComponent(QString const& name)
{
    LOG_DEBUG("addComponent(" << name << ")");

    ComponentSharedPointer component = instantiateComponent(name);
    mgr_->registerComponent(component, name);
}
