#ifndef IN_OUT_BASE_H
#define IN_OUT_BASE_H

#include <Pacpus/kernel/ConnectionBase.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/PacpusEvent.h>
#include <Pacpus/kernel/PacpusLibConfig.h>

#include <boost/smart_ptr/shared_ptr.hpp>
//#include <boost/smart_ptr/weak_ptr.hpp>
#include <QList>
#include <QString>
#include <QStringList>
#include <typeinfo>

class QByteArray;

namespace pacpus
{

class ComponentBase;

class PACPUSLIB_API AbstractInterface
    : public QObject
{
     Q_OBJECT

protected:
    AbstractInterface(QString name, ComponentBase * component, QObject * parent = 0);
    virtual ~AbstractInterface();

public:
    QString getSignature() const;
    QString getName() const;
    virtual std::size_t getDataSize() const = 0;
    virtual const std::type_info & getDataType() const = 0;
    
    //virtual PacpusEvent * getEventTemplate() = 0;
    
    void addConnection(ConnectionBase connection);
    bool removeConnection(ConnectionBase connection);
    bool hasConnection();
    
protected:
    QList<ConnectionBase> & connections();
    const QList<ConnectionBase> & getConnections() const;

    ComponentBase * component();
    const ComponentBase * getComponent() const;
    
private:
    QString m_name;
    ComponentBase * m_component;
    QList<ConnectionBase> m_connections;
};

class PACPUSLIB_API InputInterfaceBase
    : public AbstractInterface
{
    Q_OBJECT

protected:
    // TODO: add ctor with function pointer
    InputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0);

public:
    enum ReadingMode {
        NeverSkip,
        TimeBounded,
        GetLast
    };

    virtual ~InputInterfaceBase();

    virtual void customEvent(QEvent * e);

    ReadingMode & readingMode();
    const ReadingMode & getReadingMode() const;
    void setReadingMode(ReadingMode mode);

    // FIXME: what's the purpose of this function?
    virtual PacpusEvent * getEventTemplate();
    
private:
    ReadingMode m_readingMode;

    // metode(QByteArray)
    //QQueue jobQueue_;
};

class PACPUSLIB_API OutputInterfaceBase
    : public AbstractInterface
{
    Q_OBJECT

public:
    OutputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0)
        : AbstractInterface(name, component, parent)
    {}

    virtual ~OutputInterfaceBase()
    {}

    QStringList getInputConnectedList();

    //void send(/*const*/ QByteArray & data);
};

typedef boost::shared_ptr<InputInterfaceBase> InputSharedPointer;
typedef boost::shared_ptr<OutputInterfaceBase> OutputSharedPointer;

} // namespace pacpus

#endif // IN_OUT_BASE_H
