/**
@file
Purpose: Lidar Detection

@date created 2010-06-03 16:13
@author Julien Moras
@version $Id: $
*/

#ifndef PRODUCEREXAMPLE_H
#define PRODUCEREXAMPLE_H

#include "ProducerConsumerExampleConfig.h"

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/road_time.h>
//#include <Pacpus/structure/genericStructures.h>

#include <boost/asio.hpp>
#include <boost/date_time/posix_time/posix_time_types.hpp>
#include <fstream>
#include <QImage>

namespace pacpus
{

class PRODUCERCONSUMEREXAMPLE_API ProducerExample
    : public QObject
    , public ComponentBase
{
    Q_OBJECT

public:
    static const char * COMPONENT_TYPE;

    ProducerExample(QString name);
    ~ProducerExample();

    virtual void addInputs();
    virtual void addOutputs();
    
    virtual void startActivity();
    virtual void stopActivity();

    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

private:
    void produce(int& counter);

private:
    std::string mOutputFileName;

    std::fstream mFile;
    OutputInterface<QImage, ProducerExample>* mImageOutput;

    boost::asio::io_service mIo;
    boost::posix_time::time_duration mInterval;
    boost::asio::deadline_timer mTimer;
};

} // namespace pacpus

#endif // PRODUCEREXAMPLE_H
