#ifndef CONSUMEREXAMPLE_H
#define CONSUMEREXAMPLE_H

#include "ProducerConsumerExampleConfig.h"

#include <fstream>
#include <Pacpus/kernel/ComponentBase.h>
#include <QImage>
#include <QThread>
#include <string>

namespace pacpus
{

class PRODUCERCONSUMEREXAMPLE_API ConsumerExample
    : public QObject
    , public ComponentBase
{
    Q_OBJECT

public:
    ConsumerExample(QString name);
    ~ConsumerExample();

    virtual void stopActivity();
    virtual void startActivity();
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    void process(const QImage& matrix);

private:
    virtual void addInputs();
    virtual void addOutputs();

    QImage matrix;

    int m_counter;
    std::ofstream m_file;

    std::string mOutputFileName;
    QThread mThread;
};

} // namespace pacpus

#endif // CONSUMEREXAMPLE_H
