// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    2014-04-07 10:32:10
/// @version $Id$
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef PACPUS_PREDEF_VERSION_NUMBER_H
#define PACPUS_PREDEF_VERSION_NUMBER_H

#define PACPUS_VERSION_NUMBER(major,minor,patch) \
    ( (((major)%100)*10000000) + (((minor)%100)*100000) + ((patch)%100000) )

#define PACPUS_VERSION_NUMBER_MAX \
    PACPUS_VERSION_NUMBER(99,99,99999)

#define PACPUS_VERSION_NUMBER_ZERO \
    PACPUS_VERSION_NUMBER(0,0,0)

#define PACPUS_VERSION_NUMBER_MIN \
    PACPUS_VERSION_NUMBER(0,0,1)

#define PACPUS_VERSION_NUMBER_AVAILABLE \
    PACPUS_VERSION_NUMBER_MIN

#define PACPUS_VERSION_NUMBER_NOT_AVAILABLE \
    PACPUS_VERSION_NUMBER_ZERO

#endif // PACPUS_PREDEF_VERSION_NUMBER_H
