// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    2014-04-07 10:36:35
/// @version $Id$
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef PACPUS_PREDEF_OS_H
#define PACPUS_PREDEF_OS_H

#include <Pacpus/predef/version_number.h>

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_OS_WINDOWS PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(_WIN32) || defined(_WIN64) || \
    defined(__WIN32__) || defined(__TOS_WIN__) || \
    defined(__WINDOWS__)
#   undef PACPUS_OS_WINDOWS
#   define PACPUS_OS_WINDOWS PACPUS_VERSION_NUMBER_AVAILABLE
#endif

#if PACPUS_OS_WINDOWS
#   define PACPUS_OS_WINDOWS_AVAILABLE
#endif

#define PACPUS_OS_WINDOWS_NAME "Microsoft Windows"

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_OS_UNIX PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(unix) || defined(__unix) || \
    defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE)
#   undef PACPUS_OS_UNIX
#   define PACPUS_OS_UNIX PACPUS_VERSION_NUMBER_AVAILABLE
#endif

#if PACPUS_OS_UNIX
#   define PACPUS_OS_UNIX_AVAILABLE
#endif

#define PACPUS_OS_UNIX_NAME "Unix Environment"

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_OS_LINUX PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(linux) || defined(__linux)
#   undef PACPUS_OS_LINUX
#   define PACPUS_OS_LINUX PACPUS_VERSION_NUMBER_AVAILABLE
#endif

#if PACPUS_OS_LINUX
#   define PACPUS_OS_LINUX_AVAILABLE
#endif

#define PACPUS_OS_LINUX_NAME "Linux"

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_OS_MACOS PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(macintosh) || defined(Macintosh) || \
    (defined(__APPLE__) && defined(__MACH__))
#   undef PACPUS_OS_MACOS
#   if !defined(PACPUS_OS_MACOS) && defined(__APPLE__) && defined(__MACH__)
#       define PACPUS_OS_MACOS PACPUS_VERSION_NUMBER(10,0,0)
#   endif
#   if !defined(PACPUS_OS_MACOS)
#       define PACPUS_OS_MACOS PACPUS_VERSION_NUMBER(9,0,0)
#   endif
#endif

#if PACPUS_OS_MACOS
#   define PACPUS_OS_MACOS_AVAILABLE
#endif

#define PACPUS_OS_MACOS_NAME "Mac OS"

////////////////////////////////////////////////////////////////////////////////

#endif // PACPUS_PREDEF_OS_H
