/// ********************************************************************
///  @date created 2006/12/30 - 17:31
///  @author Gerald Dherbomez
///  @version $Id: Win32ShMem.h 930 2012-03-28 08:30:14Z kurdejma $
/// *********************************************************************

#ifndef WIN32SHMEM_H
#define WIN32SHMEM_H

#include "ShMemBase.h"

typedef void * HANDLE;

class Win32ShMem
        : public ShMemBase
{
public:
    Win32ShMem(const char * name, int size);
    ~Win32ShMem();

    virtual bool wait(unsigned long timeout = 0);
    virtual void * read();
    virtual void read(void * mem, int size);
    virtual void write(void * data, int size, unsigned long offset = 0);
    virtual void lockMemory();
    virtual void unlockMemory();
    virtual void * getEventIdentifier();

protected:  

private:
    HANDLE semaphore_;
    HANDLE shMemHandle_;
    HANDLE event_;
};

#endif // WIN32SHMEM_H
