/*********************************************************************
// created:    2006/02/07 - 11:58
// filename:   ComponentBase.cpp
//
// author:     Gerald Dherbomez
// 
// purpose:    implementation of ComponentBase class
*********************************************************************/

#include "kernel/ComponentBase.h"

#include "kernel/ComponentManager.h"
#include "kernel/Log.h"

namespace pacpus {

DECLARE_STATIC_LOGGER("pacpus.core.ComponentBase");

ComponentBase::ComponentBase(QString name)
{
    LOG_TRACE("constructor");

    configuration_ = NOT_CONFIGURED;
    componentName = name;
    recording = true;
    THREAD_ALIVE = true;
    mIsActive = 0;
    componentState_ = ComponentBase::NOT_MONITORED;

    // we get a pointer on the instance of ComponentManager
    mgr = ComponentManager::getInstance();

    LOG_INFO("component " << componentName
             << " was created"
             );
}

ComponentBase::~ComponentBase()
{  
    LOG_TRACE("destructor");
}

//TODO
//COMPONENT_CONFIGURATION ComponentBase::configureComponent(XmlComponentConfig config)
//{
//}

int ComponentBase::startComponent()
{
    if (mIsActive == 0) {
        mIsActive = 1;
        startActivity();
        return 1;
    } else {
        return 0;
    }
}

int ComponentBase::stopComponent()
{
    if (mIsActive == 1) {
        mIsActive = 0;
        stopActivity();
        return 1;
    } else {
        return 0;
    }
}

void ComponentBase::setState(const COMPONENT_STATE state)
{
    if (state != componentState_) {
        componentState_ = state;
    }
}

// return the state of the component 
ComponentBase::COMPONENT_STATE ComponentBase::getState()
{
    COMPONENT_STATE state = componentState_;
    if (ComponentBase::NOT_MONITORED != componentState_) {
        componentState_ = ComponentBase::MONITOR_NOK;
    }
    return state;
}

} // namespace pacpus
