/*********************************************************************
// created:    2007/04/12 - 16:30

//
// author:     Elie Al Alam & Gerald Dherbomez
//
// version:    $Id: $
//
// purpose:    Dbite Player Engine state chart header file
*********************************************************************/

#ifndef DBTPLYENGINESTATECHART_H
#define DBTPLYENGINESTATECHART_H

#include <qstring.h>

#include "DbitePlayerConfig.h"

namespace pacpus {

class DbtPlyEngine;

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API DbtPlyEngineState
{
public:
    virtual ~DbtPlyEngineState();

    virtual void play(DbtPlyEngine & engine);
    virtual void pause(DbtPlyEngine & engine);
    virtual void stop(DbtPlyEngine & engine);

    virtual void speedUp(DbtPlyEngine & engine);
    virtual void speedDown(DbtPlyEngine & engine);

    virtual bool isPlaying();

    virtual QString toString() const = 0;

protected:
    DbtPlyEngineState();
};

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API PlayingState
        : public DbtPlyEngineState
{
public:
    virtual void pause(DbtPlyEngine & engine);
    virtual void stop(DbtPlyEngine & engine);

    virtual bool isPlaying();

    virtual QString toString() const;
    static DbtPlyEngineState * getInstance();

private:
    PlayingState();
    static PlayingState mInstance;
};

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API PausedState
        : public DbtPlyEngineState
{
public:
    virtual void play(DbtPlyEngine & engine);
    virtual void stop(DbtPlyEngine & engine);

    virtual QString toString() const;
    static DbtPlyEngineState * getInstance();

private:
    PausedState();
    static PausedState mInstance;
};

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API StoppedState
        : public DbtPlyEngineState
{
public:
    virtual void play(DbtPlyEngine & engine);

    virtual QString toString() const;
    static DbtPlyEngineState * getInstance();

private:
    StoppedState();
    static StoppedState mInstance;
};

} // namespace pacpus

#endif // DBTPLYENGINESTATECHART_H
