/*********************************************************************
// created:    2007/04/12 - 16:30

//
// author:     Elie Al Alam & Gerald Dherbomez
// 
// version:    $Id: $
//
// purpose:    Dbite Player Trigger header file
*********************************************************************/

#ifndef DBTPLYTRIGGER_H
#define DBTPLYTRIGGER_H

#include <qthread.h>

#include "DbitePlayerConfig.h"
#include "kernel/ComponentBase.h"
#include "kernel/ComponentFactory.h"
#include "DbitePlayer/DbtPlyEngine.h"

#ifdef WIN32
#   include <windows.h>
#   include <mmsystem.h>
#endif

namespace pacpus {

class DbtPlyEngine;

class DBITE_PLAYER_API DbtPlyTrigger
        : public QThread
        , public ComponentBase
{    
    Q_OBJECT

public:
    DbtPlyTrigger(QString name);
    virtual ~DbtPlyTrigger();

    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    virtual void run();

Q_SIGNALS:
    void triggerSig();

protected:
    virtual void startActivity();
    virtual void stopActivity();

private:
    DbtPlyEngine * mEngine;
};

} // namespace pacpus

#endif // DBTPLYTRIGGER_H
