/*********************************************************************
//  created:    2006/12/30 - 17:19
//  filename:   ShMem.h
//
//  author:     Gerald Dherbomez
// 
//  version:    $Id: ShMem.h 914 2012-03-07 15:57:43Z kurdejma $
//
//  purpose:    Generic Win32 and Linux class for the exchange of 
//              data via shared memory. 
*********************************************************************/

#ifndef SHMEM_H
#define SHMEM_H

#ifdef WIN32
#   include "Win32ShMem.h"
#   define ShMemType Win32ShMem
#else
#   include "PosixShMem.h"
#   define ShMemType PosixShMem
#endif

namespace pacpus {

class ShMem
        : public ShMemType
{
public:
    ShMem(const char * name, int size)
        : ShMemType(name, size)
    {
    }

    ~ShMem()
    {
    }

protected:
private:
};

} // namespace pacpus

#endif // SHMEM_H
