/*********************************************************************
//  created:    2006/12/30 - 17:35
//  filename:   ShMemBase.h
//
//  author:     Gerald Dherbomez
// 
//  version:    $Id: ShMemBase.h 929 2012-03-27 15:49:00Z kurdejma $
//
//  purpose:    Abstract class for shared memory
*********************************************************************/

#ifndef SHMEMBASE_H
#define SHMEMBASE_H

class ShMemBase
{
public:
  ShMemBase()
  {
      /*printf("ShMemBase::ShMemBase() not implemented !\n");*/
  }

  virtual ~ShMemBase()
  {
      /*printf("ShMemBase::~ShMemBase() not implemented !\n");*/
  }

  // Use this method to get the data of the shared memory
  virtual void *read() = 0; 

  // Use this method to write data in shared memory
  virtual void write(void *data, int size, unsigned long offset = 0) = 0; 

  // Use this method to wait the incoming of new data
  // you can specify a timeout in ms to avoid infinite blocking or 0 (infinite)
  // return true if new data available before the timeout or else false
  virtual bool wait(unsigned long timeout = 0) = 0; 

  // To lock the access to the memory
  virtual void lockMemory() = 0; 

  // To unlock the access to the memory
  virtual void unlockMemory() = 0; 

#ifdef WIN32
  // Return the event handle under Windows 
  // ... under Linux ? 
  virtual void * getEventIdentifier() = 0; 
#endif 
  
protected:
  void * shMem_; 
	
private:
};

#endif // SHMEMBASE_H
