#ifndef MATRIX_H
#define MATRIX_H

typedef enum
{
    ONES,
    ZEROS,
    IDENTITY
} t_m;

class matrice
{
    typedef double *ligne;
    ligne *lignes;
    unsigned short int n;   // Nombre de lignes (1erparamètre).
    unsigned short int m;   // Nombre de colonnes (2èmeparamètre).

public:
    //constructeurs
    matrice();
    matrice(unsigned short int nl, unsigned short int nc);
    matrice(unsigned short int nl, unsigned short int nc,t_m type);
    matrice(const matrice &source); //constructeur par copie
    //destructeur
    virtual ~matrice(void);
    void Alloue(unsigned short int nl, unsigned short int nc); //allocation de la matrice

    // fonction pour le calcul de matrice 
    matrice &operator=(const matrice &m);//m=m1
    matrice &operator=(double x); //m=x
    operator double()const{return **lignes;}

    matrice &operator+=(const matrice &m); //m+=m1
    matrice &operator-=(const matrice &m); //m-=m1

    matrice operator+(const matrice &m1) const; //m=m1+m2
    matrice operator-(const matrice &m1) const; //m=m1-m2
    matrice operator*(const matrice &m1) const; //m=m1*m2

    matrice &operator+=(double x); //m+=x
    matrice &operator-=(double x); //m-=x

    matrice operator+(double x)const; //m+x
    matrice operator-(double x)const; //m-x
    matrice operator*(double x)const; //m*x
    matrice operator/(double x)const; //m/x

    friend matrice operator+(double x,matrice m1) {return m1+x ;} // x+m ;
    friend matrice operator-(double x,matrice m1) {return m1-x ;} // x-m ;
    friend matrice operator*(double x,matrice m1) {return m1*x ;} // x*m ;

    matrice T(); //transposition
    matrice I(); //inversion

    double &operator()(unsigned short int i, unsigned short int j); // ecriture m(i,j)=x
    double operator()(unsigned short int i, unsigned short int j) const; //lecture x=m(i,j)
    double &operator()(unsigned short int i); // ecriture m(i)=x
    double operator()(unsigned short int i) const; //lecture x=m(i)

    void print(const char *nom);
};

#endif // MATRIX_H
