// ********************************************************************
//  created:    2006/02/14 - 16:07
//  filename:   ComponentFactoryBase.cpp
//
//  author:     Gerald Dherbomez
//
//  purpose:    Implementation of ComponentFactoryBase class
// *********************************************************************

#include "kernel/ComponentFactoryBase.h"

#include "kernel/ComponentBase.h"
#include "kernel/ComponentManager.h"
#include "kernel/Log.h"

#include <cassert>
#include <QString>

namespace pacpus {

DECLARE_STATIC_LOGGER("pacpus.core.ComponentFactoryBase");

ComponentFactoryBase::ComponentFactoryBase()
{
    LOG_TRACE("constructor");

    // get the adress of the ComponentManager instance
    mgr_ = ComponentManager::getInstance();
}

ComponentFactoryBase::~ComponentFactoryBase()
{
    LOG_TRACE("destructor");
}

void ComponentFactoryBase::addFactory(ComponentFactoryBase * addr, const QString & type)
{
    LOG_DEBUG("addFactory(type="<< type << ")");

    assert(mgr_);
    if (!mgr_->registerComponentFactory(addr, type)) {
        /*
        // FIXME: delete in a secure manner (no double delete)
        delete addr;
        addr = NULL;
        */
    }
}

void ComponentFactoryBase::addComponent(const QString & name)
{
    LOG_DEBUG("addComponent(" << name << ")");

    // FIXME: instantiated component is never deleted!
    // who should do it? ComponentManager?
    ComponentBase * addr = instantiateComponent(name);
    assert(mgr_);
    if (!mgr_->registerComponent(addr, name)) {
        delete addr;
        addr = NULL;
    }
}

} // namespace pacpus
