/*********************************************************************
// created:    2007/04/12 - 16:30
//
// author:     Elie Al Alam & Gerald Dherbomez
//             Heudiasyc UMR UTC/CNRS 6599 Copyright
// 
// version:    $Id: $
//
// purpose:    Dbite Player User interface header file
*********************************************************************/

#ifndef DBTPLYUSERINTERFACE_H
#define DBTPLYUSERINTERFACE_H

#include <qwidget.h>

#include "kernel/ComponentBase.h"
#include "kernel/ComponentFactory.h"
#include "DbitePlayerConfig.h"
#include "DbtPlyFileManager.h"
#include "DbtPlyEngine.h"

class QButtonGroup;
class QCheckBox;
class QCloseEvent;
class QGroupBox;
class QLabel;
class QLayout;
class QPushButton;
class QSlider;
class QTableWidget;

namespace pacpus {
    
class DbtPlyEngine;
class DbtPlyEngineState;

class DBITE_PLAYER_API DbtPlyUserInterface
        : public QWidget
        , public ComponentBase
{
    Q_OBJECT

public:
    /// Constructor.
    ///
    /// @param name component name
    /// @see ComponentBase::ComponentBase(QString)
    DbtPlyUserInterface(QString name);

    /// Destructor.
    ~DbtPlyUserInterface();

    /// @returns time slider value
    int getTime();

    /// sets time slider value to 0
    void resetTime();

public Q_SLOTS:
    /// Slot.
    /// Refreshes the state of the player.
    void displayStateSlot(DbtPlyEngineState * state, float speed);

    /// Slot.
    /// Displays the max and min times.
    void displayMinMaxTime(road_time_t min, road_time_t max);

    /// Slot.
    /// Displays the current time of the player.
    void displayTime(road_time_t time);

private:
    /// Configures the component.
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    /// Starts component activity.
    virtual void startActivity();

    /// Stops component activity.
    virtual void stopActivity();

    void closeEvent(QCloseEvent * e);

    void connectButtons();
    void connectDisplay();
    void connectSlider();
    QLayout * createMainLayout();
    QGroupBox * createControlGroupBox();
    QGroupBox * createComponentListGroupBox();
    void updateComponentList();
    
private:
    DbtPlyEngine * mEngine;

    QWidget * wTel_ ;
    QButtonGroup * butGroup;
    QPushButton * playBut ;
    QPushButton * pauseBut ;
    QPushButton * stopBut ;
    QPushButton * speedUpBut ;
    QPushButton * speedDownBut ;
    QLabel * lab;
    QCheckBox * rev;
    QSlider * timeSlider;
    QLabel * timeMinTitle;
    QLabel * timeMinValue;
    QLabel * timeMaxTitle;
    QLabel * timeMaxValue;
    QLabel * timeCurTitle;
    QLabel * timeCurValue;

    QTableWidget * componentTableWidget;

    // current max time
    road_time_t tMax_;
    // current min time
    road_time_t tMin_;
    // current absolute time
    road_time_t absTime_;
    // current relative time
    int relTime_;
};

} // namespace pacpus

#endif // DBTPLYUSERINTERFACE_H
