// ********************************************************************
//  created:    2006/02/14 - 15:39
//  filename:   ComponentFactory.h
//
//  author:     Gerald Dherbomez
//
//  purpose:    Template class ComponentFactory.
//              Use it to interface your components with the application
// *********************************************************************

#ifndef COMPONENTFACTORY_H
#define COMPONENTFACTORY_H

#include "ComponentFactoryBase.h"

#include <QString>

/** Register a component to the factory.
 * @className Name of the class, without the quotes.
 * @factoryName Name of the class in the factory.
 */
#define REGISTER_COMPONENT(className, factoryName) \
  static pacpus::ComponentFactory<className> sFactory(factoryName)

namespace pacpus {

template <typename T>
class ComponentFactory
        : public ComponentFactoryBase
{
public:
    ComponentFactory(QString type);
    virtual ~ComponentFactory();

    const QString & getType() const;

protected:
    virtual ComponentBase * instantiateComponent(const QString & name);

private:
    QString mType;
};

////////////////////////////////////////////////////////////////////////////////
template <typename T>
ComponentFactory<T>::ComponentFactory(QString type)
    : mType(type)
{
    addFactory(this, mType);
}

template<typename T>
ComponentFactory<T>::~ComponentFactory()
{
}

template <typename T>
const QString & ComponentFactory<T>::getType() const
{
    return mType;
}

template<typename T>
ComponentBase * ComponentFactory<T>::instantiateComponent(const QString & name)
{
    T * component = new T(name);
    return component;
}

} // namespace pacpus

#endif // COMPONENTFACTORY_H
