#pragma once
#ifndef __GENERIC_OBSERVER_INTERFACE_H__
#define __GENERIC_OBSERVER_INTERFACE_H__

namespace pacpus {

/** Base class for te GenericObserverInterface template.

    The purpose of this class is to be able to take generic pointers on
    GenericObserverInterface<T> class template instances.
*/
class GenericObserverBase {
public:
  virtual ~GenericObserverBase() {}
};

/** Template interface for generic observers.
  
    This is a pure virtual class that should be used as a base to classes 
    wishing to receive notifications from GenericObservable classes.
*/
template <typename T> 
class GenericObserverInterface : public GenericObserverBase {
public:
  virtual ~GenericObserverInterface() {};

  /** Update function.

      This function is called each time the observables notifies its observers
      of a change. It must be implemented by all classes obeying the 
      GenericObserverInterface interface.

      @param observable is a pointer to the observed object that was updated.
  */
  virtual void update(T* observable) = 0;
};

} // namespace pacpus


#endif