#include "ProducerExample.h"

#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/InputOutputInterface.h>
#include <Pacpus/kernel/Log.h>

#include <boost/bind.hpp>
#include <boost/thread.hpp>

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.cityvip.test.ProducerExample");

PACPUS_REGISTER_COMPONENT(ProducerExample);

ProducerExample::ProducerExample(QString name)
    : ComponentBase(name)
    , mInterval(boost::posix_time::milliseconds(150))
    , mTimer(mIo, mInterval)
{
    PACPUS_LOG_FUNCTION();

    namespace po = boost::program_options;
    
    addParameters()
        ("output-path", po::value<std::string>(&mOutputFileName)->default_value("producer.txt"), "set output file path")
    ;
}

ProducerExample::~ProducerExample()
{
    PACPUS_LOG_FUNCTION();
}

ComponentBase::COMPONENT_CONFIGURATION ProducerExample::configureComponent(XmlComponentConfig /*config*/)
{
    PACPUS_LOG_FUNCTION();

    LOG_INFO("component '" << getName() << "' configured");
    return ComponentBase::CONFIGURED_OK;
}
    
void ProducerExample::addInputs()
{
    // empty: no inputs
}

void ProducerExample::addOutputs()
{
    addOutput<QImage, ProducerExample>("image");
}

void ProducerExample::startActivity()
{
    PACPUS_LOG_FUNCTION();

    using boost::bind;
    using boost::ref;

    std::fstream mFile(mOutputFileName.c_str(), std::ios_base::out | std::ios_base::app);
    if (!mFile.is_open()) {
        LOG_ERROR("file '" << mOutputFileName << "' cannot be opened");
        return;
    }

    mImageOutput = getTypedOutput<QImage, ProducerExample>("image");

    setActive(true);
    setState(MONITOR_OK);
    LOG_INFO("started component '" << getName() << "'");

    int counter = 0;
    mTimer.async_wait(bind(&ProducerExample::produce, this, ref(counter)));
    boost::thread t(bind(&boost::asio::io_service::run, ref(mIo)));
    //mIo.run();
}

void ProducerExample::stopActivity()
{
    PACPUS_LOG_FUNCTION();

    setActive(false);
    setState(STOPPED);
    LOG_INFO("stopped component '" << getName() << "'");
    
    mFile.close();
}

void ProducerExample::produce(int& counter)
{
    if (!isActive()) {
        return;
    }
    
    QImage mat(10, 10, QImage::Format_RGB32);
    //mat.fill( qRgb(189, 149, 39));
    //mat.setPixel(0,0,i);
    LOG_INFO("Sending QImage: "
        << "size = " << mat.size().width()<< " x " << mat.size().height()
        );

    checkedSend(mImageOutput, mat);
    LOG_INFO("Sent data=" << counter << ", time=" << road_time());
    mFile << counter << " " << road_time() << "\n" << std::flush;
    ++counter;
    setState(MONITOR_OK);
    
    using boost::bind;
    using boost::ref;
    mTimer.expires_at(mTimer.expires_at() + mInterval);
    mTimer.async_wait(bind(&ProducerExample::produce, this, ref(counter)));
}
