#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

################################################################################
# OUTPUT
set(PACPUS_DEPENDENCIES_INC "")
set(PACPUS_DEPENDENCIES_LIB "")

################################################################################
# Necessary for Qt5
# message(STATUS "Set CMake variable 'CMAKE_PREFIX_PATH' to the path like '%QT_BIN%/../lib/cmake'")
set(QT_CMAKE_DIR "$ENV{QT_BIN}/../lib/cmake")
get_filename_component(QT_CMAKE_DIR "${QT_CMAKE_DIR}" ABSOLUTE)
if(DEBUG)
    message(STATUS "\${QT_CMAKE_DIR} = '${QT_CMAKE_DIR}'")
endif()
list(APPEND CMAKE_PREFIX_PATH
    ${QT_CMAKE_DIR}
)
if(WIN32)
    set(WINSDK_LIB "$ENV{WINSDK_LIB}" CACHE PATH "Directory of Windows Development Kit, should contain glu32.lib.")
    if("${WINSDK_LIB}" STREQUAL "")
        message(STATUS "Environment variable 'WINSDK_LIB' should be set to something like 'C:/Program Files (x86)/Windows Kits/8.0/Lib/win8/um/x86'")
    endif()
    if(DEBUG)
        message(STATUS "\$ENV{WINSDK_LIB} = '$ENV{WINSDK_LIB}'")
        message(STATUS "\${WINSDK_LIB} = '${WINSDK_LIB}'")
    endif()
    list(APPEND CMAKE_PREFIX_PATH
        ${WINSDK_LIB}
    )
endif()
if(DEBUG)
    message(STATUS "\${CMAKE_PREFIX_PATH} = '${CMAKE_PREFIX_PATH}'")
endif()

################################################################################
# Find Qt
find_package(Qt5Widgets QUIET)
if(Qt5Widgets_FOUND)
    # Tell CMake to run moc when necessary:
    #set(CMAKE_AUTOMOC ON)
    # As moc files are generated in the binary dir, tell CMake
    # to always look for includes there:
    set(CMAKE_INCLUDE_CURRENT_DIR ON)        
    
    find_package(Qt5Core REQUIRED)
    find_package(Qt5Xml REQUIRED)
    find_package(Qt5Gui REQUIRED)
    #find_package(Qt5OpenGL REQUIRED)
    #find_package(Qt5Network REQUIRED)
    #find_package(Qt5SerialPort REQUIRED)
        
    set(QT_DEFINITIONS
        ${Qt5Widgets_DEFINITIONS}
        ${Qt5Core_DEFINITIONS}
        ${Qt5Xml_DEFINITIONS}
        ${Qt5Gui_DEFINITIONS}
        ${Qt5OpenGL_DEFINITIONS}
        ${Qt5Network_DEFINITIONS}
        ${Qt5SerialPort_DEFINITIONS}
    )
    set(QT_INCLUDE_DIR
        ${Qt5Widgets_INCLUDE_DIRS}
        ${Qt5Core_INCLUDE_DIRS}
        ${Qt5Xml_INCLUDE_DIRS}
        ${Qt5Gui_INCLUDE_DIRS}
        ${Qt5OpenGL_INCLUDE_DIRS}
        ${Qt5Network_INCLUDE_DIRS}
        ${Qt5SerialPort_INCLUDE_DIRS}
    )
    set(QT_LIBRARIES
        ${Qt5Widgets_LIBRARIES}
        ${Qt5Core_LIBRARIES}
        ${Qt5Xml_LIBRARIES}
        ${Qt5Gui_LIBRARIES}
        ${Qt5OpenGL_LIBRARIES}
        ${Qt5Network_LIBRARIES}
        ${Qt5SerialPort_LIBRARIES}
    )
    
    if(Qt5_POSITION_INDEPENDENT_CODE)
      set(CMAKE_POSITION_INDEPENDENT_CODE ON)
    endif()
else()
    message(STATUS "Qt5 not found: try to find Qt4")
    
    find_package(Qt4 REQUIRED QtCore QtGui QtXml)
    include(${QT_USE_FILE})
endif()

################################################################################
# All the Pacpus modules depend on Qt5
# However, since each module requires specific Qt's modules, they have to include their own QT_USE_FILE

################################################################################
# Boost
set(Boost_USE_STATIC_LIBS       OFF)
set(Boost_USE_MULTITHREADED      ON)
set(Boost_USE_STATIC_RUNTIME    OFF)
list(APPEND PACPUS_DEFINITIONS " -DBOOST_ALL_DYN_LINK ")
if(CMAKE_COMPILER_IS_GNUC)
    list(APPEND PACPUS_DEFINITIONS " -lpthread ")
endif()
find_package(Boost 1.54.0
    COMPONENTS
        chrono # thread
        date_time # thread
        program_options #1.32.0
        system # log, thread needed on Linux
        thread
)
if(Boost_FOUND)
    include_directories(${Boost_INCLUDE_DIRS})
    link_directories(${Boost_LIBRARY_DIRS})
    list(APPEND PACPUS_DEPENDENCIES_INC ${Boost_INCLUDE_DIRS})
    list(APPEND PACPUS_DEPENDENCIES_LIB ${Boost_LIBRARIES})
endif()

if(PACPUS_USE_LOG)
    find_package(Boost 1.54.0 REQUIRED
        COMPONENTS
            #filesystem
            log # 1.54.0
            log_setup # log
    )
    list(APPEND PACPUS_DEPENDENCIES_INC ${Boost_INCLUDE_DIRS})
    list(APPEND PACPUS_DEPENDENCIES_LIB ${Boost_LIBRARIES})
endif()
if(PACPUS_BUILD_TESTS)
    find_package(Boost 1.21.0 REQUIRED
        COMPONENTS
            unit_test_framework
    )
    list(APPEND PACPUS_DEPENDENCIES_INC ${Boost_INCLUDE_DIRS})
    list(APPEND PACPUS_DEPENDENCIES_LIB ${Boost_LIBRARIES})
endif()

################################################################################
# DOCUMENTATION
if(PACPUS_BUILD_DOC)
    find_package(Doxygen)
    if(NOT DOXYGEN_FOUND)
        message(FATAL_ERROR "Doxygen is needed to build the documentation. Please install it correctly")
    endif()
endif()
