#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

# TODO: write the output variables of this CMake file.

# Check PACPUS_ROOT
if(NOT PACPUS_ROOT)
	if(NOT ENV{PACPUS_ROOT} STREQUAL "")
		set(PACPUS_ROOT $ENV{PACPUS_ROOT})
		string (REPLACE "\\" "/" PACPUS_ROOT ${PACPUS_ROOT})
		message(STATUS "Detected PACPUS_ROOT in environment, set to '${PACPUS_ROOT}'")
	else()
		if(PACPUS_FIND_REQUIRED)
			MESSAGE(FATAL_ERROR "Could'not find PACPUS_ROOT ")
		else()
			MESSAGE(STATUS "Could'not find PACPUS_ROOT ")
			return()
		endif()
	endif()
else()
	string (REPLACE "\\" "/" PACPUS_ROOT ${PACPUS_ROOT})
	message(STATUS "Detected PACPUS_ROOT as argument with the path: '${PACPUS_ROOT}'")
endif()


# Locate the include files
set(PACPUS_INCLUDE_DIR
	"${PACPUS_ROOT}/include"
)

if(NOT PACPUS_INCLUDE_DIR)
	message(FATAL_ERROR "Could not find PACPUS. Please set CMake variable PACPUS_ROOT or environment variable PACPUS_ROOT.")
endif()

#get_filename_component(PACPUS_ROOT ${PACPUS_INCLUDE_DIR}/.. ABSOLUTE)
set(PACPUS_LIB_DIR ${PACPUS_ROOT}/lib)

# List of required modules
set(PACPUS_MODULES "FileLib" "PacpusLib" "PacpusTools" "dbiteplayerlib")
if(WIN32)
	list(APPEND PACPUS_MODULES "ROAD_TIME")
endif()

set(MODULE_MISSING FALSE)
set(PACPUS_LIBRARIES "")

message (${PACPUS_LIB_DIR})

# Check the presence of each module
foreach(module ${PACPUS_MODULES})

	# release version
	find_library(
		PACPUS_${module}_LIB
		NAMES ${module}
		HINTS ${PACPUS_LIB_DIR}
	)
	if(PACPUS_${module}_LIB)
		list(APPEND PACPUS_LIBRARIES optimized ${PACPUS_${module}_LIB})
	else()
		message(SEND_ERROR "Cannot find Pacpus module ${module} (release version)")
		set(MODULE_MISSING TRUE)
	endif()
    	
	# debug version
	find_library(
		PACPUS_${module}_LIBD
		NAMES ${module}_d
		HINTS ${PACPUS_LIB_DIR}
	)
	if(PACPUS_${module}_LIBD)
		list(APPEND PACPUS_LIBRARIES debug ${PACPUS_${module}_LIBD})
	else()
		message(SEND_ERROR "Cannot find Pacpus module ${module}_d (debug version)")
		set(MODULE_MISSING TRUE)
	endif()
	
endforeach()

# handle the QUIETLY and REQUIRED arguments and set PACPUS_FOUND to TRUE if
# all listed variables are TRUE
include (FindPackageHandleStandardArgs)
set(PACPUS_ALL_MODULES_FOUND NOT MODULE_MISSING)
find_package_handle_standard_args (PACPUS DEFAULT_MSG PACPUS_LIBRARIES PACPUS_INCLUDE_DIR PACPUS_ALL_MODULES_FOUND)

if(PACPUS_FOUND)
	set(PACPUS_INSTALL_DIR ${PACPUS_ROOT})
	set(PACPUS_CMAKE_DIR ${PACPUS_ROOT}/cmake)
	set(CMAKE_INSTALL_PREFIX ${PACPUS_INSTALL_DIR})
	list(APPEND CMAKE_PREFIX_PATH ${PACPUS_CMAKE_DIR})
	list(APPEND CMAKE_MODULE_PATH "${PACPUS_CMAKE_DIR}")

	include(${PACPUS_CMAKE_DIR}/PacpusUtilities.cmake)
	include(${PACPUS_CMAKE_DIR}/PacpusConfiguration.cmake)
	include(${PACPUS_CMAKE_DIR}/PacpusDependencies.cmake)
	include(${PACPUS_CMAKE_DIR}/PacpusPlatforms.cmake)
endif()